<?php

use App\Models\UserNotifications;
use LaravelFCM\Message\OptionsBuilder;
use LaravelFCM\Message\PayloadDataBuilder;
use LaravelFCM\Message\PayloadNotificationBuilder;
use LaravelFCM\Facades\FCM;
use App\User;
use App\Models\Rides;
use App\Models\RideTransaction;
use Omnipay\Omnipay;

use Omnipay\Gateway;


if ( ! function_exists( 'assginTrip' ) ) {
    /**
     * Get Total Refunded Amount order
     * @param $id
     *
     * @return  float|integer
     */
    function assginTrip($tripID)
    {
        $ride = Rides::with(['weight', 'trucktype', 'user', 'driver','ridestracking','status','ridestatus'])->where('id',$tripID)->first();


        $lon = $ride->pickup_long;
        $lat = $ride->pickup_lat;


        $data = DB::table("drivers")
            ->select("drivers.id"
                ,DB::raw("6371 * acos(cos(radians(" . $lat . "))
                * cos(radians(drivers.lat))
                * cos(radians(drivers.long) - radians(" . $lon . "))
                + sin(radians(" .$lat. "))
                * sin(radians(drivers.lat))) AS distance"))
            ->whereNotIN('drivers.id',\App\Models\DriverTripsHistory::where('ride_id',$ride->id)->pluck('driver_id')->toArray())
            ->groupBy("drivers.id")
            ->get();
        $driver = ($data->first());
        if(!$driver){return;}
        $ride->driver_id = $driver->id;
        $ride->save();
        $ride->refresh();
        \App\Models\DriverTripsHistory::create(['driver_id'=>$driver->id,'ride_id'=>$ride->id]);
        $user = \App\Models\Customer::where('id',$ride->user_id)->first();
         $tokens =  $user->device_token;
        $title = 'Ride # '. $ride->id.' Changed to Status'.$ride->status->title_en ;
        $body = 'Driver : ' .$ride->driver->full_name .' Changed to Status'.$ride->status->title_en;
         (sendNotifications([$tokens], $title, $body));

        $driver = \App\Models\Driver::where('id',$ride->driver_id)->first();
        $tokens =  $driver->device_token;
        $title = 'Ride # '. $ride->id;
        $body = 'Ride # '. $ride->id.' Changed to Status'.$ride->status->title_en ;
        (sendNotifications([$tokens], $title, $body));
    }
}
