<?php

use App\Models\UserNotifications;
use LaravelFCM\Message\OptionsBuilder;
use LaravelFCM\Message\PayloadDataBuilder;
use LaravelFCM\Message\PayloadNotificationBuilder;
use LaravelFCM\Facades\FCM;
use App\User;
use App\Models\Rides;
use App\Models\RideTransaction;
use Omnipay\Omnipay;

use Omnipay\Gateway;


if ( ! function_exists( 'sendNotifications' ) ) {
    /**
     * Get Total Refunded Amount order
     * @param $id
     *
     * @return  float|integer
     */
    function sendNotifications($tokens, $title, $body)
    {
        $recipients = $tokens;

        return (fcm()
            ->to($recipients)
            ->priority('high')
            ->timeToLive(0)
            ->notification([
                'title' => $title,
                'type'>'1',
                'body' => $body,
            ])
            ->send());
    }
}
