<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\ContactRequest as StoreRequest;
// VALIDATION: change the requests to match your own file names if you need form validation
use App\Models\Customer;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Illuminate\Support\Facades\App;

class ContactCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation { store as traitStore; }
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation { update as traitUpdate; }
    use \Backpack\CRUD\app\Http\Controllers\Operations\CloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkDeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkCloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\InlineCreateOperation;

    public function setup()
    {
        App::setLocale(session('locale'));

        CRUD::setModel(\App\Models\ContactUs::class);
        CRUD::setRoute(config('backpack.base.route_prefix').'/contact');
        CRUD::setEntityNameStrings(trans('admin.contact'), trans('admin.contact'));
    }

    protected function setupListOperation()
    {

        $this->crud->addColumn([
            'name'=>'type',
            'label'=>'Type'
        ]);

        $this->crud->addColumn([
            'name'=>'name',
            'label'=>'Name'
        ]);
        $this->crud->addColumn([
            'name'=>'patient_name',
            'label'=>'Patient Name'
        ]);
        $this->crud->addColumn([
            'name'=>'position',
            'label'=>'position'
        ]);
        $this->crud->addColumn([
            'name'=>'company',
            'label'=>'company'
        ]);

        $this->crud->addColumn([
            'name'=>'enquires',
            'label'=>'enquires'
        ]);
        $this->crud->addColumn([
            'name'=>'message',
            'label'=>'message'
        ]);
        $this->crud->addColumn([
            'name'=>'mobile',
            'label'=>'mobile'
        ]);
        $this->crud->addColumn([
            'name'=>'inner_name',
            'label'=>'inner name'
        ]);
        $this->crud->addColumn([
            'name'=>'inner_company',
            'label'=>'inner company'
        ]);
        $this->crud->addColumn([
            'name'=>'facts',
            'label'=>'facts'
        ]);
        $this->crud->addColumn([
            'name'=>'communicated_facts',
            'label'=>'communicated facts'
        ]);
        $this->crud->addColumn([
            'name'=>'eduaction',
            'label'=>'eduaction'
        ]);
        $this->crud->addColumn([
            'name'=>'email',
            'label'=>'email'
        ]);
        $this->crud->addColumn([
            'name'=>'compaints_affects',
            'label'=>'complaints affects'
        ]);
        $this->crud->addColumn([
            'name'=>'address',
            'label'=>'address'
        ]);
   
      $this->crud->addColumn([
            'name'=>'created_at',
            'label'=>'Sent At'
        ]);

        $this->crud->enableExportButtons();
        $this->crud->enableDetailsRow();


        $this->crud->disableResponsiveTable();

        $this->crud->enablePersistentTable();
        $this->crud->removeAllButtons();
    }
        protected function showDetailsRow($id)
    {
        $msg  = \App\Models\ContactUs::where('id',$id)->first();
        $text = '<div class="row">';
        $text .= '<div class="col-12">';
         
        $text.= 'Message : '.$msg->message ; 

        $text.= '</div>';
  
        $text.= '</div>';

        return $text;
    }


    protected function setupCreateOperation()
    {
        CRUD::setValidation(StoreRequest::class);

        CRUD::addField([ // Text
            'name'  => 'name',
            'label' => trans('admin.Name'),
            'type'  => 'text',
            'tab'   => 'Texts',

        ]);
        CRUD::addField([ // Text
            'name'  => 'mobile',
            'label' => trans('admin.Mobile'),
            'type'  => 'text',
            'tab'   => 'Texts',

        ]);
        CRUD::addField([ // Text
            'name'  => 'title',
            'label' => trans('admin.Subject'),
            'type'  => 'text',
            'tab'   => 'Texts',

        ]);
        CRUD::addField([ // Text
            'name'  => 'message',
            'label' => trans('admin.Message'),
            'type'  => 'text',
            'tab'   => 'Texts',

        ]);



        $this->crud->setOperationSetting('contentClass', 'col-md-12');
    }

    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
