<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\SlidersRequest as StoreRequest;
// VALIDATION: change the requests to match your own file names if you need form validation
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Illuminate\Support\Facades\App;

class DivisionsCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkDeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkCloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\InlineCreateOperation;

    public function setup()
    {
        App::setLocale(session('locale'));

        CRUD::setModel(\App\Models\Divisions::class);
        CRUD::setRoute(config('backpack.base.route_prefix').'/divisions');
        CRUD::setEntityNameStrings(trans('admin.divisions'), trans('admin.Divisions'));
    }

    protected function setupListOperation()
    {
        $this->crud->addColumn(['name'=>'title','label'=>trans('admin.Title')]);
         $this->crud->addColumn([ // Text
            'name' => 'order',
            'label' => 'Sort']);

        $this->crud->enableExportButtons();
        $this->crud->enableResponsiveTable();
        $this->crud->enablePersistentTable();
    }

    protected function setupCreateOperation()
    {
//        CRUD::setValidation(StoreRequest::class);

        CRUD::addField([ // Text
            'name' => 'title_en',
            'label' => trans('admin.Title En'),
            'type' => 'text',
            'tab' => 'Texts',

        ]);
        CRUD::addField([ // Text
            'name' => 'title_ar',
            'label' => trans('admin.Title Ar'),
            'type' => 'text',
            'tab' => 'Texts',

        ]);
        CRUD::addField([ // Text
            'name' => 'order',
            'label' => 'Sort',
            'type' => 'number',
            'tab' => 'Texts',

        ]);
        CRUD::addField([ // Text
            'name' => 'breif_en',
            'label' => 'Breif En',
            'type' => 'text',
            'tab' => 'Texts',

        ]);
        CRUD::addField([ // Text
            'name' => 'breif_ar',
            'label' => 'Breif Ar',
            'type' => 'text',
            'tab' => 'Texts',

        ]);

        CRUD::addField([
            'label' => trans('admin.description_en'),
            'name' => "description_en",
            'type' => 'ckeditor',
            'tab' => 'Texts',
            'aspect_ratio' => 1, // omit or set to 0 to allow any aspect ratio
            // 'disk'      => 's3_bucket', // in case you need to show images from a different disk
            // 'prefix'    => 'uploads/images/profile_pictures/' // in case your db value is only the file name (no path), you can use this to prepend your path to the image src (in HTML), before it's shown to the user;
        ]);

        CRUD::addField([
            'label' => trans('admin.description_ar'),
            'name' => "description_ar",
            'type' => 'ckeditor',
            'tab' => 'Texts',
            'aspect_ratio' => 1, // omit or set to 0 to allow any aspect ratio
            // 'disk'      => 's3_bucket', // in case you need to show images from a different disk
            // 'prefix'    => 'uploads/images/profile_pictures/' // in case your db value is only the file name (no path), you can use this to prepend your path to the image src (in HTML), before it's shown to the user;
        ]);

        CRUD::addField([
            'label' => 'Short description en',
            'name' => "short_description_en",
            'type' => 'ckeditor',
            'tab' => 'Texts',
            'aspect_ratio' => 1, // omit or set to 0 to allow any aspect ratio
            // 'disk'      => 's3_bucket', // in case you need to show images from a different disk
            // 'prefix'    => 'uploads/images/profile_pictures/' // in case your db value is only the file name (no path), you can use this to prepend your path to the image src (in HTML), before it's shown to the user;
        ]);

        CRUD::addField([
            'label' => 'Short description ar',
            'name' => "short_description_ar",
            'type' => 'ckeditor',
            'tab' => 'Texts',
            'aspect_ratio' => 1, // omit or set to 0 to allow any aspect ratio
            // 'disk'      => 's3_bucket', // in case you need to show images from a different disk
            // 'prefix'    => 'uploads/images/profile_pictures/' // in case your db value is only the file name (no path), you can use this to prepend your path to the image src (in HTML), before it's shown to the user;
        ]);
    CRUD::addField([
            'name' => 'banners',
            'label' => 'Banner Image',
            'type' => 'upload_multiple',
            'upload' => true,
        'tab'   => 'Texts',

    ], 'both');
        CRUD::addField([
            'label' => trans('admin.photo'),
            'name' => "image",
            'type' => 'image',
            'tab'   => 'Texts',
            'crop' => false, // set to true to allow cropping, false to disable
            'aspect_ratio' => 1, // omit or set to 0 to allow any aspect ratio
            // 'disk'      => 's3_bucket', // in case you need to show images from a different disk
            // 'prefix'    => 'uploads/images/profile_pictures/' // in case your db value is only the file name (no path), you can use this to prepend your path to the image src (in HTML), before it's shown to the user;
        ]);
        CRUD::addField([
            'label' => 'Inner Image',
            'name' => "innerimage",
            'type' => 'image',
            'tab'   => 'Texts',
            'crop' => false, // set to true to allow cropping, false to disable
            'aspect_ratio' => 1, // omit or set to 0 to allow any aspect ratio
            // 'disk'      => 's3_bucket', // in case you need to show images from a different disk
            // 'prefix'    => 'uploads/images/profile_pictures/' // in case your db value is only the file name (no path), you can use this to prepend your path to the image src (in HTML), before it's shown to the user;
        ]);

        CRUD::addField([
            'label' => 'Extra Data',
            'name' => "extra_data",
            'type' => 'ckeditor',
            'tab'   => 'Texts',
            'crop' => false, // set to true to allow cropping, false to disable
            'aspect_ratio' => 1, // omit or set to 0 to allow any aspect ratio
            // 'disk'      => 's3_bucket', // in case you need to show images from a different disk
            // 'prefix'    => 'uploads/images/profile_pictures/' // in case your db value is only the file name (no path), you can use this to prepend your path to the image src (in HTML), before it's shown to the user;
        ]);
        CRUD::addField([ // Text
            'name'  => 'status',
            'label' => trans('admin.Active'),
            'type'  => 'radio',
            'tab'   => 'Texts',
            'options'     => [
                // the key will be stored in the db, the value will be shown as label;
                0 => "No",
                1 => "Yes"
            ],

        ]);

        $this->crud->setOperationSetting('contentClass', 'col-md-12');
    }

    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
