<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\ContactRequest as StoreRequest;
// VALIDATION: change the requests to match your own file names if you need form validation
use App\Models\Customer;
use App\Models\Webnotifications;
use App\Models\Driver;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Illuminate\Support\Facades\App;

class NotificationsCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation { store as traitStore; }
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation { update as traitUpdate; }
    use \Backpack\CRUD\app\Http\Controllers\Operations\CloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkDeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkCloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\InlineCreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation {
        store as traitStore;
    }
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation {
        update as traitUpdate;
    }

    public function setup()
    {
        App::setLocale(session('locale'));

        CRUD::setModel(\App\Models\Webnotifications::class);
        CRUD::setRoute(config('backpack.base.route_prefix').'/notifications');
        CRUD::setEntityNameStrings(trans('admin.notifications'), trans('admin.notifications'));
    }

    protected function setupListOperation()
    {

        $this->crud->addColumn([
            'name'=>'title',
            'label'=>trans('admin.Subject')
        ]);


        $this->crud->enableExportButtons();
        $this->crud->disableDetailsRow();


        $this->crud->disableResponsiveTable();

        $this->crud->enablePersistentTable();
    }

    protected function setupCreateOperation()
    {
//        CRUD::setValidation(StoreRequest::class);

        CRUD::addField([ // Text
            'name'  => 'title',
            'label' => trans('admin.title'),
            'type'  => 'text',
            'tab'   => 'Texts',

        ]);
        CRUD::addField([ // Text
            'name'  => 'body',
            'label' => trans('admin.Message'),
            'type'  => 'text',
            'tab'   => 'Texts',

        ]);

        CRUD::addField([   // select_from_array
            'name'        => 'user_type',
            'label'       => "For",
            'type'        => 'select_from_array',
            'options'     => ['0' => 'All', '1' => 'Customers' , '2'=>'Drivers'],
            'allows_null' => false,
            'default'     => '0',
            // 'allows_multiple' => true, // OPTIONAL; needs you to cast this to array in your model;
        ]);



        $this->crud->setOperationSetting('contentClass', 'col-md-12');
    }

    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
    public function store()
    {
        $this->crud->setRequest($this->crud->validateRequest());
        $this->crud->unsetValidation(); // validation has already been run


        $response = $this->traitStore();
        $notification =Webnotifications::find($this->crud->entry->id);
        if($notification->user_type == 0 )
        {
                $tokens = Driver::pluck('device_token')->toArray();
            $tokens = array_merge($tokens, Customer::pluck('device_token')->toArray());
        }
        else if($notification->user_type == 1 )
        {
            $tokens = Customer::pluck('device_token')->toArray();
        }
        else
        {
            $tokens = Driver::pluck('device_token')->toArray();

        }
        $result = sendNotifications($tokens, $notification->title, $notification->body);

        return $response;
    }
}
