<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\FaqRequest as StoreRequest;
// VALIDATION: change the requests to match your own file names if you need form validation
use App\Models\Customer;
use App\Models\Driver;
use App\Models\Rides;
use App\Models\TruckType;
use App\Models\Weights;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class OrderReportsCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkDeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkCloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\InlineCreateOperation;

    public function setup()
    {
        App::setLocale(session('locale'));

        CRUD::setModel(\App\Models\Rides::class);
        CRUD::setRoute(config('backpack.base.route_prefix').'/rides');
        CRUD::setEntityNameStrings(trans('admin.rides'), trans('admin.rides'));
    }

    protected function setupListOperation()
    {
        $this->crud->addColumn([ // Text
            'name' => 'created_at',
            'orderable' => false,
            'label' => trans('admin.Date'),
        ]);

        $this->crud->addColumn([ // Text
            'name' => 'user',
            'orderable' => false,
            'label' => 'Customer',
            'type' => 'relationship'
        ]);
        $this->crud->addColumn([ // Text
            'name' => 'driver',
            'orderable' => false,
            'label' => 'Driver',
            'type' => 'relationship'
        ]);

        $this->crud->addColumn([ // Text
            'name' => 'status',
            'orderable' => false,
            'label' => 'Status',
            'type' => 'relationship'
        ]);

        $this->crud->addColumn([ // Text
            'name' => 'amount',
            'label' => 'Amount',
            'orderable' => true,
            'orderLogic' => function ($query, $column, $columnDirection) {
                return $query->orderBy('amount', $columnDirection);
            }
        ]);

        $this->crud->removeAllButtons();
        $this->crud->enableExportButtons();
        $this->crud->enableResponsiveTable();
        $this->crud->enablePersistentTable();
    }

    protected function setupCreateOperation()
    {
//        CRUD::setValidation(StoreRequest::class);

        CRUD::addField([  // Select2
            'label' => trans('admin.Customer'),
            'type' => 'relationship',
            'name' => 'user_id', // the db column for the foreign key
            'entity' => 'user', // the method that defines the relationship in your Model
            'attribute' => 'info', // foreign key attribute that is shown to use
            'tab' => 'Texts',
            'attributes' => [
                'class' => 'form-control custlmer-class'],
            'data_source' => url("/admin/fetch/bookingphonecustomer"), // url to controller search function (with /{id} should return model)
        ]);
        CRUD::addField([  // Select2
            'label' => trans('admin.Driver'),
            'type' => 'relationship',
            'name' => 'driver_id', // the db column for the foreign key
            'entity' => 'driver', // the method that defines the relationship in your Model
            'attribute' => 'info', // foreign key attribute that is shown to use
            'tab' => 'Texts',
            'attributes' => [
                'class' => 'form-control custlmer-class'],
            'data_source' => url("/admin/fetch/bookingphonedriver"), // url to controller search function (with /{id} should return model)
        ]);
        CRUD::addField([
            // 1-n relationship
            'tab' => 'Texts',
            'label'     => 'Status', // Table column heading
            'type'      => 'select',
            'name'      => 'status_id', // the column that contains the ID of that connected entity;
            'entity'    => 'status', // the method that defines the relationship in your Model
            'attribute' => 'title_en', // foreign key attribute that is shown to user
            'model'     => "App\Models\Status", // foreign key model
        ]);
        CRUD::addField([
            // select_from_array
            'tab' => 'Texts',
            'name'    => 'type',
            'label'   => 'Type',
            'type'    => 'select_from_array',
            'options' => ['now' => 'now', 'schedule' => 'schedule'],
        ]);
        CRUD::addField([
            // select_from_array
            'tab' => 'Texts',
            'name'    => 'requesd_time',
            'label'   => 'Requesd Time',
            'type'    => 'datetime',
        ]);
        CRUD::addField([  // Select2
            'label' => trans('admin.truck_type'),
            'type' => 'relationship',
            'name' => 'truck_type', // the db column for the foreign key
            'entity' => 'trucktype', // the method that defines the relationship in your Model
            'attribute' => 'title_en', // foreign key attribute that is shown to use
            'tab' => 'Texts',
            'attributes' => [
                'class' => 'form-control custlmer-class'],
            'data_source' => url("/admin/fetch/bookingtrucktype"), // url to controller search function (with /{id} should return model)
        ]);
        CRUD::addField([  // Select2
            'label' => trans('admin.weight'),
            'type' => 'relationship',
            'name' => 'weight_id', // the db column for the foreign key
            'entity' => 'weight', // the method that defines the relationship in your Model
            'attribute' => 'title', // foreign key attribute that is shown to use
            'tab' => 'Texts',
            'attributes' => [
                'class' => 'form-control custlmer-class'],
            'data_source' => url("/admin/fetch/bookingweight"), // url to controller search function (with /{id} should return model)
        ]);
        CRUD::addField([
            // select_from_array
            'tab' => 'Texts',
            'name'    => 'payment_type',
            'label'   => 'Payment Method',
            'type'    => 'select_from_array',
            'options' => [Rides::KNET => 'KNET', Rides::CASH => 'CASH'],
        ]);
        CRUD::addField([  // Select2
            'label' => trans('admin.PickUp'),
            'tab' => 'Texts',
            'type' => 'address_google',
            'name' => 'pickupjson', // the db column for the foreign key
            'store_as_json' => true
        ]);
        CRUD::addField([  // Select2
            'label' => trans('admin.amount'),
            'tab' => 'Texts',
            'type' => 'text',
            'name' => 'amount', // the db column for the foreign key
        ]);
        CRUD::addField([  // Select2
            'label' => trans('admin.notes'),
            'tab' => 'Texts',
            'type' => 'textarea',
            'name' => 'notes', // the db column for the foreign key
        ]);

        $this->crud->setOperationSetting('contentClass', 'col-md-12');
    }

    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
    public function fetchphonecustomer(Request $request)
    {
        $users = Customer::where('phone','like','%'.$request->q.'%')
            ->get();
        $data = [] ;
        foreach ($users as $user)
        {
            $data[] = ['id'=>$user->id , 'info'=>'Name : '.$user->full_name.' - Phone : '.$user->phone.' - Civil Id : '.$user->civil_id];
        }
        return $data;
    }
    public function fetchphonedriver(Request $request)
    {
        $users = Driver::where('phone','like','%'.$request->q.'%')
            ->get();
        $data = [] ;
        foreach ($users as $user)
        {
            $data[] = ['id'=>$user->id , 'info'=>'Name : '.$user->full_name.' - Phone : '.$user->phone];
        }
        return $data;
    }
    public function fetchTrucKType(Request $request)
    {
        $users = TruckType::where('title_en','like','%'.$request->q.'%')
            ->orWhere('title_ar','like','%'.$request->q.'%')
            ->get();
        $data = [] ;
        foreach ($users as $user)
        {
            $data[] = ['id'=>$user->id , 'title_en'=>$user->title_en];
        }
        return $data;
    }
    public function fetchWeight(Request $request)
    {
        $users = Weights::where('title','like','%'.$request->q.'%')
            ->get();
        $data = [] ;
        foreach ($users as $user)
        {
            $data[] = ['id'=>$user->id , 'title'=>$user->title];
        }
        return $data;
    }
}
