<?php

namespace App\Http\Controllers\Admin;

use App\Events\Event;
use App\Http\Requests\PagesRequest as StoreRequest;
// VALIDATION: change the requests to match your own file names if you need form validation
use App\Models\Booking;
use App\Models\PaymentLog;
use Illuminate\Http\Request;
use App\Models\Customer;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Hash;

class PagesCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation { store as traitStore; }
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation { update as traitUpdate; }
    use \Backpack\CRUD\app\Http\Controllers\Operations\CloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkDeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\BulkCloneOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\InlineCreateOperation;

    public function setup()
    {
        App::setLocale(session('locale'));

        CRUD::setModel(\App\Models\Pages::class);
        CRUD::setRoute(config('backpack.base.route_prefix').'/pages');
        CRUD::setEntityNameStrings(trans('admin.pages'), trans('admin.pages'));
    }

    protected function setupListOperation()
    {
        $this->crud->addFilter([
            'name'        => 'id',
            'type'        => 'select2_ajax',
            'label'       => trans('admin.Student'),
            'placeholder' => 'Name , Phone Or Civil Id'
        ],
            url('admin/fetch/bookingfilteruser'), // the ajax route
            function($value) { // if the filter is active
                $this->crud->addClause('where', 'id', $value);
            });
         $this->crud->addColumn([ // Text
            'name'  => 'name_en',
            'label' => trans('admin.Name'),
         ]);

        $this->crud->enableExportButtons();
        $this->crud->enableResponsiveTable();
        $this->crud->enablePersistentTable();
        $this->crud->enableDetailsRow();
    }

    protected function setupCreateOperation()
    {
        CRUD::setValidation(StoreRequest::class);


        CRUD::addField([ // Text
            'name'  => 'name_en',
            'label' => trans('admin.name_en'),
            'type'  => 'text',
            'tab'   => 'Texts',
        ]);


        CRUD::addField([ // Text
            'name'  => 'description_en',
            'label' => trans('admin.description_en'),
            'type'  => 'ckeditor',
            'tab'   => 'Texts',
        ]);

        CRUD::addField([ // Text
            'name'  => 'name_ar',
            'label' => trans('admin.name_ar'),
            'type'  => 'text',
            'tab'   => 'Texts',
        ]);


        CRUD::addField([ // Text
            'name'  => 'description_ar',
            'label' => trans('admin.description_ar'),
            'type'  => 'ckeditor',
            'tab'   => 'Texts',
        ]);

        CRUD::addField([ // Text
            'name'  => 'slug',
            'label' => trans('admin.slug'),
            'type'  => 'text',
            'tab'   => 'Texts',
        ]);

        CRUD::addField([
            'label' => trans('admin.photo'),
            'name' => "image",
            'type' => 'image',
            'tab'   => 'Texts',
            'crop' => false, // set to true to allow cropping, false to disable
            'aspect_ratio' => 1, // omit or set to 0 to allow any aspect ratio
            // 'disk'      => 's3_bucket', // in case you need to show images from a different disk
            // 'prefix'    => 'uploads/images/profile_pictures/' // in case your db value is only the file name (no path), you can use this to prepend your path to the image src (in HTML), before it's shown to the user;
        ]);

        $this->crud->setOperationSetting('contentClass', 'col-md-12');
    }
    public function update()
    {
        $this->crud->setRequest($this->crud->validateRequest());
        $this->crud->setRequest($this->handlePasswordInput($this->crud->getRequest()));
        $this->crud->unsetValidation(); // validation has already been run
        $response = $this->traitUpdate();
        return $response;
    }
    public function store()
    {

        $this->crud->setRequest($this->crud->validateRequest());
        $this->crud->setRequest($this->handlePasswordInput($this->crud->getRequest()));
        $this->crud->unsetValidation(); // validation has already been run

        $response = $this->traitStore();
        return $response;
    }
        protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
    public function fetchStudentDetails(Request $request)
    {
        $student = Customer::find($request->id);
        return ($student);
    }
    public function studentOptions(Request $request) {
        $term = $request->input('term');
        $options =  Customer::where('phone','like',"%".$term."%")
            ->orWhere('full_name','like',"'%".$term."%")
            ->orWhere('grandfather_name','like',"%".$term."%")
            ->orWhere('father_name','like',"%".$term."%")
            ->orWhere('family_name','like',"%".$term."%")
            ->orWhere('civil_id','like',"%".$term."%")->get();
        $data = [];
        foreach ($options as $option)
        {
            $data [$option->id] = $option->phone .' '.$option->civil_id;

        }
        return $data;
    }
    public function chngUserStatus(Request $request)
    {
        $customer = Customer::find($request->id);
        if($customer->active)
        {
            $isactive =  0;
            $customer->active = 0 ;
        }
        else
        {
            $isactive =  1;
            $customer->active = 1 ;
        }
        $customer->save();
        return $isactive;

    }
    protected function handlePasswordInput($request)
    {
        // Remove fields not present on the user.
        $request->request->remove('password_confirmation');
        $request->request->remove('roles_show');
        $request->request->remove('permissions_show');

        // Encrypt password if specified.
        if ($request->input('password')) {
            $request->request->set('password', Hash::make($request->input('password')));
        } else {
            $request->request->remove('password');
        }

        return $request;
    }
}
