<?php

namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\eventsRequest;
use App\Models\News;
use App\Traits\allTraits;

class eventsController extends Controller
{

    use allTraits;

    public function events() {

        $news =  News::All();
        return view('vendor.backpack.news', compact('news'));
    }


    public function addEvents() {

        return view('vendor.backpack.addNews');
    }





    public function eventsPost(eventsRequest $request)
    {

        $photo = array();
        if($files = $request->file('photo')){
            foreach($files as $file){
                $photo_name = md5(rand(1000, 10000));
                $ext = strtolower($file->getClientOriginalExtension());
                $photo_full_name = $photo_name.'.'.$ext;
                $upload_path = 'images/events/';
                $photo_url = $upload_path.$photo_full_name;
                $file->move($upload_path, $photo_full_name);
                $photo[] = $photo_url;
            }
        }

        $file_name = $this->saveImage($request->image, 'images/events');
        News::create([
            'photo' => implode('|', $photo),
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'description_ar' => $request -> description_ar,
            'description_en' => $request -> description_en,
            'date' => $request -> date,
            'image' => $file_name,
        ]);

        return redirect()->back()->with(['successAdd' => '']);

    }



    public function deleteNews($news_id)
    {
        $news =  News::find($news_id);

        if (!$news)
            return redirect()->back()->with(['error' => __('messages.news not exist')]);

        $news->delete();

        return redirect()
            ->route('events')
            ->with(['successDelete' => __('messages.news deleted successfully')]);

    }








    public function editEvents($news_id)
    {

        // addNews::findOrFail($news_id);
        $News = News::find($news_id);  // search in given table id only
        if (!$News)
            return redirect()->back();

        $news = News::all()->find($news_id);
        return view('vendor.backpack.editNews', compact('news'));
    }


    public function UpdateEvents(eventsRequest $request, $news_id)
    {


        $News = News::find($news_id);
        if (!$News)
            return redirect()->back();

        //update data
        $photo = array();
        if($files = $request->file('photo')){
            foreach($files as $file){
                $photo_name = md5(rand(1000, 10000));
                $ext = strtolower($file->getClientOriginalExtension());
                $photo_full_name = $photo_name.'.'.$ext;
                $upload_path = 'images/events/';
                $photo_url = $upload_path.$photo_full_name;
                $file->move($upload_path, $photo_full_name);
                $photo[] = $photo_url;
            }
        }

        $file_name = $this->saveImage($request->image, 'images/events');


        $News->update([
            'photo' => implode('|', $photo),
            'title_ar' => $request -> title_ar,
            'title_en' => $request -> title_en,
            'description_ar' => $request -> description_ar,
            'description_en' => $request -> description_en,
            'date' => $request -> date,
            'image' => $file_name,
        ]);



        return redirect()->back()->with(['successEdit' => ' تم التحديث بنجاح ']);


        /*
        $addNews->update($request->all());
        */

    }







}
