<?php

namespace App\Http\Controllers;
use App\Mail\CareersMail;
use App\Models\Candidates;
use App\Models\Settings;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\Careers;
use App\Models\Banner;
use App\Models\Complaints;
use App\Models\ContactusRequests;
use App\Models\DriverRequests;
use App\Models\Divisions;
use App\Models\Enquires;
use App\Models\News;
use App\Models\Pages;
use App\Models\Services;
use App\Models\Sliders;
use App\Models\Works;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Models\Setting;
use App\Models\Contact;
use App\Traits\allTraits;
use App\Mail\ContactUsMail;
use Mail;
use Image;
use function Psy\bin;
use Illuminate\Support\Facades\App;use Validator;
class PagesController extends Controller
{


    use allTraits;

    public function search(Request  $request)
    {
        $banner = Banner::where('page', 'division')->first();

        $page = Page::where('slug', $request->slug)->first();
        $divisions = Divisions::where('title_en','like','%'.$request->search.'%')->orWhere('title_ar','like','%'.$request->search.'%')->get();
        $setting = Setting::first();
        return view('Pages.search')->with(['page'=>$page,'setting'=>$setting,'divisions'=>$divisions,'banner'=>$banner ]);
    }
    public function switchlang(Request $request)
    {

        Session()->put('locale', $request->lang);
        App::setLocale($request->lang);
        app()->setLocale($request->lang);

         (app()->getLocale());
        return redirect()->back();
    }
    public function index(Request $request)
    {
        $page = Page::where('slug', $request->slug)->first();
        $setting = Setting::first();
        return view('Pages.page')->with(['page'=>$page,'setting'=>$setting ]);

    }

    public function division(Request $request)
    {
        $banner = Banner::where('page', 'division')->first();
        $page = Page::where('slug', $request->slug)->first();
        $divisions = Divisions::all();
        $setting = Setting::first();
        return view('Pages.division')->with(['page'=>$page,'setting'=>$setting,'divisions'=>$divisions,'banner'=>$banner ]);

    }
    public function divisiondetails(Request $request)
    {
        $banner = Banner::where('page', 'divison_details')->first();

        $page = Page::where('slug', $request->slug)->first();
        $divisions = Divisions::find($request->id);
        $setting = Setting::first();
        return view('Pages.divisiondetails')->with(['page'=>$page,'setting'=>$setting,'divisions'=>$divisions,'banner'=>$banner  ]);

    }

    public function structure(Request $request)
    {
        $page = Page::where('slug', 'structure')->first();
         $setting = Setting::first();
        return view('Pages.structure')->with(['page'=>$page,'setting'=>$setting ]);
    }



    public function postContactUs(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'captcha' => 'required|captcha'
        ]);

        $rules = ['captcha' => 'required|captcha'];
        $validator = validator()->make(request()->all(), $rules);


//        dd($validator->errors());
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $contactReq = ContactusRequests::create($request->all());

         try {
            $email = Settings::whereId(1)->first();
             $subject = "Contact Us";

            $bodymail = '';
            if($contactReq->type == 'contact us')
            {
                $subject = 'Contact Us';
                $to = $email->value;
                $bodymail = "
<html>
<head>
<title>Contact Us</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Enquires</strong></td>
                                                                            <td>".$contactReq->enquires."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>

</table>
</body>
</html>
";

            }
            elseif ($contactReq->type =='Quality Assurance')
            {
                $email = Settings::whereId(22)->first();
//                $to = 'info@mydragonflys.com';
                $to = $email->value;
                $subject = 'Quality Assurance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Patient Number</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Product name</strong></td>
                                                                            <td>".$contactReq->product_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Batch No</strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>

                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>


</table>
</body>
</html>
";
            }

            elseif ($contactReq->type ==='Pharmacovigilance')
            {
                $email = Settings::whereId(18)->first();
                $to = $email->value;
                $subject = 'Pharmacovigilance (Drug Safety)';
                $bodymail ="
<html>
<head>
<title>Pharmacovigilance (Drug Safety)</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Patient Name</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Reporter Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Phone Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Gender</strong></td>
                                                                            <td>".$contactReq->gender."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Drug Batch Num </strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Address</strong></td>
                                                                            <td>".$contactReq->address."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Case Severity</strong></td>
                                                                            <td>".$contactReq->case_severity."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Does Al-Hafez Trading Company have the permission to contact you for follow up or confirmation purposes?</strong></td>
                                                                            <td>".$contactReq->company_permission."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Report Details</strong></td>
                                                                            <td>".$contactReq->report_details."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            elseif ($contactReq->type =='compliance')
            {
                $email = Settings::whereId(19)->first();
                $to = $email->value;
                $subject = 'Compliance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->designation."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Who did the misconduct / improper activity ?</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                        <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->susp_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->susp_mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->susp_email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->susp_designation."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>COMPLAINT</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q1')."</strong></td>
                                                                            <td>".$contactReq->q1."</td>
                                                                        </tr>

                                                                         <tr>
                                                                            <td><strong>".trans('website.q3')."</strong></td>
                                                                            <td>".$contactReq->q3."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q4')."</strong></td>
                                                                            <td>".$contactReq->q4."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q5')."</strong></td>
                                                                            <td>".$contactReq->q5."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q6')."</strong></td>
                                                                            <td>".$contactReq->q6."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q7')."</strong></td>
                                                                            <td>".$contactReq->q7."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q8')."</strong></td>
                                                                            <td>".$contactReq->q8."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            else
            {
                $email = Settings::whereId(20)->first();
                $to = $email->value;
                $subject = 'Cyber Security';
                $bodymail = "
                            <html>
                            <head>
                            <title>Cyber Security</title>
                            </head>
                            <body>
                            <table>
                            <tr>
                                                                                                        <td><strong>Name</strong></td>
                                                                                                        <td>".$contactReq->name."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Mobile</strong></td>
                                                                                                        <td>".$contactReq->mobile."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Email</strong></td>
                                                                                                        <td>".$contactReq->email."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Enquires</strong></td>
                                                                                                        <td>".$contactReq->enquires."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Message</strong></td>
                                                                                                        <td>".$contactReq->message."</td>
                                                                                                    </tr>

                            </table>
                            </body>
                            </html>
                            ";
            }


            $message = $bodymail;

            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-Type: text/html;". "\r\n";
            // $headers .= '--' . $boundary . "\r\n";
            $headers .= 'From: '.$contactReq->email . "\r\n";
            // $headers .= "Reply-To: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "Return-Path: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "From: The Sender <".$contactReq->email.">\r\n";

             (mail($to,$subject,$message,$headers));
        }
        catch (\Exception $exception ){}

        \Session::flash('message', 'Thank you for contact us , Will contact you soon.');
        \Session::flash('alert-class', 'alert-success');
        return redirect()->back();

    }

    public function postPharmacovigilance(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'captcha' => 'required|captcha'
        ]);

        $rules = ['captcha' => 'required|captcha'];
        $validator = validator()->make(request()->all(), $rules);


//        dd($validator->errors());
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $contactReq = ContactusRequests::create($request->all());

        try {
            $email = Settings::whereId(1)->first();
            $subject = "Contact Us";

            $bodymail = '';
            if($contactReq->type == 'contact us')
            {
                $subject = 'Contact Us';
                $to = $email->value;
                $bodymail = "
<html>
<head>
<title>Contact Us</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Enquires</strong></td>
                                                                            <td>".$contactReq->enquires."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>

</table>
</body>
</html>
";

            }
            elseif ($contactReq->type =='Quality Assurance')
            {
                $email = Settings::whereId(22)->first();
//                $to = 'info@mydragonflys.com';
                $to = $email->value;
                $subject = 'Quality Assurance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Patient Number</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Product name</strong></td>
                                                                            <td>".$contactReq->product_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Batch No</strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>

                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>


</table>
</body>
</html>
";
            }

            elseif ($contactReq->type ==='Pharmacovigilance')
            {
                $email = Settings::whereId(18)->first();
                $to = $email->value;
                $subject = 'Pharmacovigilance (Drug Safety)';
                $bodymail ="
<html>
<head>
<title>Pharmacovigilance (Drug Safety)</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Patient Name</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Reporter Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Phone Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Gender</strong></td>
                                                                            <td>".$contactReq->gender."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Drug Batch Num </strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Address</strong></td>
                                                                            <td>".$contactReq->address."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Case Severity</strong></td>
                                                                            <td>".$contactReq->case_severity."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Does Al-Hafez Trading Company have the permission to contact you for follow up or confirmation purposes?</strong></td>
                                                                            <td>".$contactReq->company_permission."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Report Details</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            elseif ($contactReq->type =='compliance')
            {
                $email = Settings::whereId(19)->first();
                $to = $email->value;
                $subject = 'Compliance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->designation."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Who did the misconduct / improper activity ?</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                        <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->susp_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->susp_mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->susp_email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->susp_designation."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>COMPLAINT</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q1')."</strong></td>
                                                                            <td>".$contactReq->q1."</td>
                                                                        </tr>

                                                                         <tr>
                                                                            <td><strong>".trans('website.q3')."</strong></td>
                                                                            <td>".$contactReq->q3."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q4')."</strong></td>
                                                                            <td>".$contactReq->q4."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q5')."</strong></td>
                                                                            <td>".$contactReq->q5."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q6')."</strong></td>
                                                                            <td>".$contactReq->q6."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q7')."</strong></td>
                                                                            <td>".$contactReq->q7."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q8')."</strong></td>
                                                                            <td>".$contactReq->q8."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            else
            {
                $email = Settings::whereId(20)->first();
                $to = $email->value;
                $subject = 'Cyber Security';
                $bodymail = "
                            <html>
                            <head>
                            <title>Cyber Security</title>
                            </head>
                            <body>
                            <table>
                            <tr>
                                                                                                        <td><strong>Name</strong></td>
                                                                                                        <td>".$contactReq->name."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Mobile</strong></td>
                                                                                                        <td>".$contactReq->mobile."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Email</strong></td>
                                                                                                        <td>".$contactReq->email."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Enquires</strong></td>
                                                                                                        <td>".$contactReq->enquires."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Message</strong></td>
                                                                                                        <td>".$contactReq->message."</td>
                                                                                                    </tr>

                            </table>
                            </body>
                            </html>
                            ";
            }


            $message = $bodymail;

            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-Type: text/html;". "\r\n";
            // $headers .= '--' . $boundary . "\r\n";
            $headers .= 'From: '.$contactReq->email . "\r\n";
            // $headers .= "Reply-To: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "Return-Path: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "From: The Sender <".$contactReq->email.">\r\n";

            (mail($to,$subject,$message,$headers));
        }
        catch (\Exception $exception ){}

        \Session::flash('message', 'Thank you for contact us , Will contact you soon.');
        \Session::flash('alert-class', 'alert-success');
        return redirect()->back();

    }
    public function pharmacovigilance(Request $request)
    {
        $banner = Banner::where('page', 'contact')->first();

        $setting = Setting::first();
        $page = Pages::whereId(5)->first();
        $complaints = Complaints::all();
        $enquires  = Enquires::all();
        $ethics = Complaints::all();
        return view('Pages.pharmacovigilance')->with(['ethics'=>$ethics,'setting'=>$setting,'page'=>$page,'enquires'=>$enquires,'complaints'=>$complaints,'banner'=>$banner]);

    }

    public function compliance(Request $request)
    {
        $banner = Banner::where('page', 'contact')->first();

        $setting = Setting::first();
        $page = Pages::whereId(5)->first();
        $complaints = Complaints::all();
        $enquires  = Enquires::all();
        $ethics = Complaints::all();
        return view('Pages.compliance')->with(['ethics'=>$ethics,'setting'=>$setting,'page'=>$page,'enquires'=>$enquires,'complaints'=>$complaints,'banner'=>$banner]);

    }
    public function postcompliance(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'captcha' => 'required|captcha'
        ]);

        $rules = ['captcha' => 'required|captcha'];
        $validator = validator()->make(request()->all(), $rules);


//        dd($validator->errors());
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $contactReq = ContactusRequests::create($request->all());

        try {
            $email = Settings::whereId(1)->first();
            $subject = "Contact Us";

            $bodymail = '';
            if($contactReq->type == 'contact us')
            {
                $subject = 'Contact Us';
                $to = $email->value;
                $bodymail = "
<html>
<head>
<title>Contact Us</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Enquires</strong></td>
                                                                            <td>".$contactReq->enquires."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>

</table>
</body>
</html>
";

            }
            elseif ($contactReq->type =='Quality Assurance')
            {
                $email = Settings::whereId(22)->first();
//                $to = 'info@mydragonflys.com';
                $to = $email->value;
                $subject = 'Quality Assurance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Patient Number</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Product name</strong></td>
                                                                            <td>".$contactReq->product_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Batch No</strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>

                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>


</table>
</body>
</html>
";
            }

            elseif ($contactReq->type ==='Pharmacovigilance')
            {
                $email = Settings::whereId(18)->first();
                $to = $email->value;
                $subject = 'Pharmacovigilance (Drug Safety)';
                $bodymail ="
<html>
<head>
<title>Pharmacovigilance (Drug Safety)</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Patient Name</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Reporter Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Phone Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Gender</strong></td>
                                                                            <td>".$contactReq->gender."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Drug Batch Num </strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Address</strong></td>
                                                                            <td>".$contactReq->address."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Case Severity</strong></td>
                                                                            <td>".$contactReq->case_severity."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Does Al-Hafez Trading Company have the permission to contact you for follow up or confirmation purposes?</strong></td>
                                                                            <td>".$contactReq->company_permission."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Report Details</strong></td>
                                                                            <td>".$contactReq->report_details."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            elseif ($contactReq->type =='compliance')
            {
                $email = Settings::whereId(19)->first();
                $to = $email->value;
                $subject = 'Compliance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->designation."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Who did the misconduct / improper activity ?</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                        <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->susp_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->susp_mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->susp_email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->susp_designation."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>COMPLAINT</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q1')."</strong></td>
                                                                            <td>".$contactReq->q1."</td>
                                                                        </tr>

                                                                         <tr>
                                                                            <td><strong>".trans('website.q3')."</strong></td>
                                                                            <td>".$contactReq->q3."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q4')."</strong></td>
                                                                            <td>".$contactReq->q4."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q5')."</strong></td>
                                                                            <td>".$contactReq->q5."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q6')."</strong></td>
                                                                            <td>".$contactReq->q6."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q7')."</strong></td>
                                                                            <td>".$contactReq->q7."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q8')."</strong></td>
                                                                            <td>".$contactReq->q8."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            else
            {
                $email = Settings::whereId(20)->first();
                $to = $email->value;
                $subject = 'Cyber Security';
                $bodymail = "
                            <html>
                            <head>
                            <title>Cyber Security</title>
                            </head>
                            <body>
                            <table>
                            <tr>
                                                                                                        <td><strong>Name</strong></td>
                                                                                                        <td>".$contactReq->name."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Mobile</strong></td>
                                                                                                        <td>".$contactReq->mobile."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Email</strong></td>
                                                                                                        <td>".$contactReq->email."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Enquires</strong></td>
                                                                                                        <td>".$contactReq->enquires."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Message</strong></td>
                                                                                                        <td>".$contactReq->message."</td>
                                                                                                    </tr>

                            </table>
                            </body>
                            </html>
                            ";
            }


            $message = $bodymail;

            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-Type: text/html;". "\r\n";
            // $headers .= '--' . $boundary . "\r\n";
            $headers .= 'From: '.$contactReq->email . "\r\n";
            // $headers .= "Reply-To: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "Return-Path: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "From: The Sender <".$contactReq->email.">\r\n";

            (mail($to,$subject,$message,$headers));
        }
        catch (\Exception $exception ){}

        \Session::flash('message', 'Thank you for contact us , Will contact you soon.');
        \Session::flash('alert-class', 'alert-success');
        return redirect()->back();

    }

    public function quality(Request $request)
    {
        $banner = Banner::where('page', 'contact')->first();

        $setting = Setting::first();
        $page = Pages::whereId(5)->first();
        $complaints = Complaints::all();
        $enquires  = Enquires::all();
        $ethics = Complaints::all();
        return view('Pages.quality')->with(['ethics'=>$ethics,'setting'=>$setting,'page'=>$page,'enquires'=>$enquires,'complaints'=>$complaints,'banner'=>$banner]);

    }
    public function security(Request $request)
    {
        $banner = Banner::where('page', 'contact')->first();

        $setting = Setting::first();
        $page = Pages::whereId(5)->first();
        $complaints = Complaints::all();
        $enquires  = Enquires::all();
        $ethics = Complaints::all();
        return view('Pages.security')->with(['ethics'=>$ethics,'setting'=>$setting,'page'=>$page,'enquires'=>$enquires,'complaints'=>$complaints,'banner'=>$banner]);

    }
    public function postQuality(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'captcha' => 'required|captcha'
        ]);

        $rules = ['captcha' => 'required|captcha'];
        $validator = validator()->make(request()->all(), $rules);


         if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $contactReq = ContactusRequests::create($request->all());

        try {
            $email = Settings::whereId(1)->first();
            $subject = "Contact Us";

            $bodymail = '';
            if($contactReq->type == 'contact us')
            {
                $subject = 'Contact Us';
                $to = $email->value;
                $bodymail = "
<html>
<head>
<title>Contact Us</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Enquires</strong></td>
                                                                            <td>".$contactReq->enquires."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>

</table>
</body>
</html>
";

            }
            elseif ($contactReq->type =='Quality Assurance')
            {
                $email = Settings::whereId(22)->first();
//                $to = 'info@mydragonflys.com';
                $to = $email->value;
                $subject = 'Quality Assurance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Patient Number</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Product name</strong></td>
                                                                            <td>".$contactReq->product_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Batch No</strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>

                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>


</table>
</body>
</html>
";
            }

            elseif ($contactReq->type ==='Pharmacovigilance')
            {
                $email = Settings::whereId(18)->first();
                $to = $email->value;
                $subject = 'Pharmacovigilance (Drug Safety)';
                $bodymail ="
<html>
<head>
<title>Pharmacovigilance (Drug Safety)</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Patient Name</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Reporter Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Phone Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Gender</strong></td>
                                                                            <td>".$contactReq->gender."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Drug Batch Num </strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Address</strong></td>
                                                                            <td>".$contactReq->address."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Case Severity</strong></td>
                                                                            <td>".$contactReq->case_severity."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Does Al-Hafez Trading Company have the permission to contact you for follow up or confirmation purposes?</strong></td>
                                                                            <td>".$contactReq->company_permission."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Report Details</strong></td>
                                                                            <td>".$contactReq->report_details."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            elseif ($contactReq->type =='compliance')
            {
                $email = Settings::whereId(19)->first();
                $to = $email->value;
                $subject = 'Compliance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->designation."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Who did the misconduct / improper activity ?</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                        <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->susp_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->susp_mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->susp_email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->susp_designation."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>COMPLAINT</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q1')."</strong></td>
                                                                            <td>".$contactReq->q1."</td>
                                                                        </tr>

                                                                         <tr>
                                                                            <td><strong>".trans('website.q3')."</strong></td>
                                                                            <td>".$contactReq->q3."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q4')."</strong></td>
                                                                            <td>".$contactReq->q4."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q5')."</strong></td>
                                                                            <td>".$contactReq->q5."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q6')."</strong></td>
                                                                            <td>".$contactReq->q6."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q7')."</strong></td>
                                                                            <td>".$contactReq->q7."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q8')."</strong></td>
                                                                            <td>".$contactReq->q8."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            else
            {
                $email = Settings::whereId(20)->first();
                $to = $email->value;
                $subject = 'Cyber Security';
                $bodymail = "
                            <html>
                            <head>
                            <title>Cyber Security</title>
                            </head>
                            <body>
                            <table>
                            <tr>
                                                                                                        <td><strong>Name</strong></td>
                                                                                                        <td>".$contactReq->name."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Mobile</strong></td>
                                                                                                        <td>".$contactReq->mobile."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Email</strong></td>
                                                                                                        <td>".$contactReq->email."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Enquires</strong></td>
                                                                                                        <td>".$contactReq->enquires."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Message</strong></td>
                                                                                                        <td>".$contactReq->message."</td>
                                                                                                    </tr>

                            </table>
                            </body>
                            </html>
                            ";
            }


            $message = $bodymail;

            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-Type: text/html;". "\r\n";
            // $headers .= '--' . $boundary . "\r\n";
            $headers .= 'From: '.$contactReq->email . "\r\n";
            // $headers .= "Reply-To: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "Return-Path: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "From: The Sender <".$contactReq->email.">\r\n";

            (mail($to,$subject,$message,$headers));
        }
        catch (\Exception $exception ){}

        \Session::flash('message', 'Thank you for contact us , Will contact you soon.');
        \Session::flash('alert-class', 'alert-success');
        return redirect()->back();

    }

    public function postSecurity(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'captcha' => 'required|captcha'
        ]);

        $rules = ['captcha' => 'required|captcha'];
        $validator = validator()->make(request()->all(), $rules);


//        dd($validator->errors());
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $contactReq = ContactusRequests::create($request->all());

        try {
            $email = Settings::whereId(1)->first();
            $subject = "Contact Us";

            $bodymail = '';
            if($contactReq->type == 'contact us')
            {
                $subject = 'Contact Us';
                $to = $email->value;
                $bodymail = "
<html>
<head>
<title>Contact Us</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Enquires</strong></td>
                                                                            <td>".$contactReq->enquires."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>

</table>
</body>
</html>
";

            }
            elseif ($contactReq->type =='Quality Assurance')
            {
                $email = Settings::whereId(22)->first();
//                $to = 'info@mydragonflys.com';
                $to = $email->value;
                $subject = 'Quality Assurance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Patient Number</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Mobile</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Product name</strong></td>
                                                                            <td>".$contactReq->product_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Batch No</strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>

                                                                        <tr>
                                                                            <td><strong>Message</strong></td>
                                                                            <td>".$contactReq->message."</td>
                                                                        </tr>


</table>
</body>
</html>
";
            }

            elseif ($contactReq->type ==='Pharmacovigilance')
            {
                $email = Settings::whereId(18)->first();
                $to = $email->value;
                $subject = 'Pharmacovigilance (Drug Safety)';
                $bodymail ="
<html>
<head>
<title>Pharmacovigilance (Drug Safety)</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Patient Name</strong></td>
                                                                            <td>".$contactReq->patient_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Reporter Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Phone Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Gender</strong></td>
                                                                            <td>".$contactReq->gender."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Drug Batch Num </strong></td>
                                                                            <td>".$contactReq->drug_batch_num."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Address</strong></td>
                                                                            <td>".$contactReq->address."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Case Severity</strong></td>
                                                                            <td>".$contactReq->case_severity."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Does Al-Hafez Trading Company have the permission to contact you for follow up or confirmation purposes?</strong></td>
                                                                            <td>".$contactReq->company_permission."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Report Details</strong></td>
                                                                            <td>".$contactReq->report_details."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            elseif ($contactReq->type =='compliance')
            {
                $email = Settings::whereId(19)->first();
                $to = $email->value;
                $subject = 'Compliance';
                $bodymail = "
<html>
<head>
<title>Compliance</title>
</head>
<body>
<table>
<tr>
                                                                            <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->designation."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Who did the misconduct / improper activity ?</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                        <td><strong>Name</strong></td>
                                                                            <td>".$contactReq->susp_name."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Contact Number</strong></td>
                                                                            <td>".$contactReq->susp_mobile."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>Email</strong></td>
                                                                            <td>".$contactReq->susp_email."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>Designation</strong></td>
                                                                            <td>".$contactReq->susp_designation."</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td><strong>COMPLAINT</strong></td>
                                                                            <td></td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q1')."</strong></td>
                                                                            <td>".$contactReq->q1."</td>
                                                                        </tr>

                                                                         <tr>
                                                                            <td><strong>".trans('website.q3')."</strong></td>
                                                                            <td>".$contactReq->q3."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q4')."</strong></td>
                                                                            <td>".$contactReq->q4."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q5')."</strong></td>
                                                                            <td>".$contactReq->q5."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q6')."</strong></td>
                                                                            <td>".$contactReq->q6."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q7')."</strong></td>
                                                                            <td>".$contactReq->q7."</td>
                                                                        </tr>
                                                                         <tr>
                                                                            <td><strong>".trans('website.q8')."</strong></td>
                                                                            <td>".$contactReq->q8."</td>
                                                                        </tr>

</table>
</body>
</html>
";
            }
            else
            {
                $email = Settings::whereId(20)->first();
                $to = $email->value;
                $subject = 'Cyber Security';
                $bodymail = "
                            <html>
                            <head>
                            <title>Cyber Security</title>
                            </head>
                            <body>
                            <table>
                            <tr>
                                                                                                        <td><strong>Name</strong></td>
                                                                                                        <td>".$contactReq->name."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Mobile</strong></td>
                                                                                                        <td>".$contactReq->mobile."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Email</strong></td>
                                                                                                        <td>".$contactReq->email."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Enquires</strong></td>
                                                                                                        <td>".$contactReq->enquires."</td>
                                                                                                    </tr>
                                                                                                    <tr>
                                                                                                        <td><strong>Message</strong></td>
                                                                                                        <td>".$contactReq->message."</td>
                                                                                                    </tr>

                            </table>
                            </body>
                            </html>
                            ";
            }


            $message = $bodymail;

            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-Type: text/html;". "\r\n";
            // $headers .= '--' . $boundary . "\r\n";
            $headers .= 'From: '.$contactReq->email . "\r\n";
            // $headers .= "Reply-To: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "Return-Path: The Sender <".$contactReq->email.">\r\n";
            // $headers .= "From: The Sender <".$contactReq->email.">\r\n";

            (mail($to,$subject,$message,$headers));
        }
        catch (\Exception $exception ){}

        \Session::flash('message', 'Thank you for contact us , Will contact you soon.');
        \Session::flash('alert-class', 'alert-success');
        return redirect()->back();

    }

    public function contactus(Request $request)
    {
        $banner = Banner::where('page', 'contact')->first();

        $setting = Setting::first();
        $page = Pages::whereId(5)->first();
        $complaints = Complaints::all();
        $enquires  = Enquires::all();
        $ethics = Complaints::all();
         return view('Pages.contactUs')->with(['ethics'=>$ethics,'setting'=>$setting,'page'=>$page,'enquires'=>$enquires,'complaints'=>$complaints,'banner'=>$banner]);
    }



    public function services(Request $request)
    {
        $services = Services::where('status',1)->get();
        return view('Pages.services')->with('services',$services);

    }
    public function servicesdetails(Request $request)
    {
        $service = Services::where('id',$request->id)->first();
        return view('Pages.servicesdetails')->with('service',$service);

    }
    public function work(Request $request)
    {
        $works = Works::where('status',1)->get();

        return view('Pages.work')->with('works',$works);

    }
    public function page(Request $request)
    {
        $page = Pages::where('slug',$request->slug)->first();
        $topBanners = Sliders::where('status',1)->where('position',1)->get();

        return view('Pages.about')->with(compact('page','topBanners'));

    }

    public function news(Request $request)
    {
        $banner = Banner::where('page', 'news_events')->first();
       $news = News::orderBy('created_at', 'desc')->get();
        $topBanners = Sliders::where('status',1)->where('position',1)->get();
        return view('Pages.news')->with(compact('news','banner'));
    }





    public function blogDetails($blogs_id)
    {

        $blogs = blog::find($blogs_id);
        if (!$blogs)
            return redirect()->back();

        $blogs = blog::select('id',
        'title_' . LaravelLocalization::getCurrentLocale() . ' as title',
        'photo',
        'date',
        'details_' . LaravelLocalization::getCurrentLocale() . ' as details')->find($blogs_id);
        $logos =  logo::All();
        $phones =  phone::All();
        $emails =  email::All();
        $addresses =  address::All();
        $white_logos =  white_logo::All();
        return view('front.blogDetails', compact('blogs', 'logos', 'phones', 'emails', 'addresses', 'white_logos'));


    }




    public function newsDetails($news_id)
    {


        $news = News::find($news_id);
        if (!$news)
            return redirect()->back();

        $news = News::all()->find($news_id);

        $banner = Banner::where('page', 'news_events')->first();
        $topBanners = Sliders::where('status',1)->where('position',1)->get();
        return view('Pages.newsDetails')->with(compact('news','banner'));


    }


    public function news2024(Request $request)
    {
        $banner = Banner::where('page', 'news_events')->first();
        $topBanners = Sliders::where('status',1)->where('position',1)->get();
        $news  = News::where('date','2024')->get();
         $news = News::orderBy('created_at', 'desc')->get();
        return view('Pages.news')->with(compact('news','banner'));
    }


    public function news2025(Request $request)
    {
        $banner = Banner::where('page', 'news_events')->first();
        $topBanners = Sliders::where('status',1)->where('position',1)->get();
        $news  = News::where('date','2025')->get();
         $news = News::orderBy('created_at', 'desc')->get();
        return view('Pages.news')->with(compact('news','banner'));
    }


    public function AllNews()
    {
        $banner = Banner::where('page', 'news_events')->first();
        $news = News::orderBy('created_at', 'desc')->get();

        return view('Pages.allNews')->with(compact('news','banner'));;
    }


    public function applyCareers(Request $request)
    {

        $file_name = $this->savepdf($request->cv, 'uploads/');

        Candidates::create([
            'cv' => $file_name,
            'eduaction' => $request -> eduaction,
            'mobile' => $request -> mobile,
        ]);

        return redirect()->back()->with(['successAdd' => '']);
    }



    public function referCareers(Request $request)
    {

        $career = Careers::where('id',$request->career_id)->first();

        try {
            $email = Settings::whereId(1)->first();
            $to = $request->ref_email;
 $subject = $career->title." Vacancy at Al-Hafez Trading company";

$message = "
<html>
<head>
 </head>
<body>
<table>
<tr>
    <td><strong>Dear $request->ref_fname $request->ref_lname </strong></td>
</tr>

<tr>
    <td>Warm greetings from Al-Hafez Trading Company !</td>
</tr>

<tr>
    <td>We hope this email finds you in good health and high spirits. We are excited to reach out to you today as you have been referred by “$request->name” for a job opportunity at our company.</td>
</tr>


<tr>
<td>$career->brief</td>
</tr>
<tr>
<td>If you find this opportunity appealing and wish to apply, kindly visit our website at https://alhafez.com.kw/careers to submit your application.</td>
</tr>
<tr><td></td></tr>
<tr><td>We look forward to hearing from you soon. </td></tr>
<tr><td></td></tr>
<tr><td>Best Regards, </td></tr>
<tr><td></td></tr>
<tr><td>HR Department </td></tr>
<tr><td>Al-Hafez Trading Company </td></tr>
</table>
</body>
</html>
";

//$boundary = str_replace(" ", "", date('l jS \of F Y h i s A'));
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-Type: text/html; \r\n";
//$headers .= '--' . $boundary . "\r\n";
$headers .= 'From: <'.$email->value.'>' . "\r\n";

($to);
// $headers .= "Reply-To: The Sender <".$to.">\r\n";
// $headers .= "Return-Path: The Sender <".$to.">\r\n";
// $headers .= "From: The Sender <".$to.">\r\n";
(mail($to,$subject,$message,$headers));
        }
        catch (\Exception $exception ){}


        return redirect()->back()->with('message', 'تم ارسال طلبك بنجاح  ');

    }
    public function careers(Request $request)
    {
        $banner = Banner::where('page', 'careers')->first();

        $careers = Careers::where('status',1)->get();

        return view('Pages.careers')->with(compact('careers','banner'));

    }

    public function loadcareerform(Request $request)
    {
        $career = Careers::where('id',$request->id)->first();
        $html = '<div class="career-item">
                        <div class="career-item_desc">
'.$career->brief.'
                            <hr>


                        </div>
                    </div>';

        if($request->type =='refer')
        {
            $html = '<form method="post" action="/careerrefer" enctype="multipart/form-data">
                        <input type="hidden" name="_token" value="'.csrf_token().'">
                        <input type="hidden" name="career_id" value="'.$request->id.'">
                        <div class="form-group">
                            <label class="mb-4 form-title">Refer a friend</label>
                            <input required="" type="text" class="form-control mb-3" name="name" placeholder="Your name">
                            <input required="" type="text" class="form-control mb-3" name="email" placeholder="Your e-mail">
                            <input required="" type="text" class="form-control mb-3" name="ref_fname" placeholder="Your referral\'s first name">
                            <input required="" type="text" class="form-control mb-3" name="ref_lname" placeholder="Your referral\'s last name">
                            <input required="" type="text" class="form-control mb-3" name="ref_email" placeholder="Your referral\'s email address">

                            <div class="row mt-4 text-center">


                                <div class="col-12 col-sm-4 text-sm-right">
                                    <button type="submit" class="btn btn-primary">Send</button>

                                </div>



                            </div>
                        </div>
                    </form>';

        }
        return json_encode(['data'=>$html]);
    }
    public function sendContactRequest(Request $request){

        $reqDriver = new DriverRequests();
        $reqDriver->name = $request->name;
        $reqDriver->phone = $request->phone;
         if($request->hasFile('working_license')){
            $image = $request->file('working_license');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->save( public_path('/uploads/' . $filename ) );
            $reqDriver->working_license = $filename;
        }
        if($request->hasFile('commercial_register')){
            $image = $request->file('commercial_register');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->save( public_path('/uploads/' . $filename ) );
            $reqDriver->commercial_register = $filename;
        }
        if($request->hasFile('driving_license')){
            $image = $request->file('driving_license');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->save( public_path('/uploads/' . $filename ) );
            $reqDriver->driving_license = $filename;
        }
        if($request->hasFile('form')){
            $image = $request->file('form');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->save( public_path('/uploads/' . $filename ) );
            $reqDriver->form = $filename;
        }
        if($request->hasFile('periodically_check')){
            $image = $request->file('periodically_check');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            Image::make($image)->save( public_path('/uploads/' . $filename ) );
            $reqDriver->periodically_check = $filename;
        }
         ($reqDriver->save());
        return redirect()->back()->with('message', 'تم استلام طلبك بنجاح سيتم الاتصال بك ');
    }


}
