<?php

namespace App\Models;

use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Illuminate\Database\Eloquent\Model;
use App\Common;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

/**
 * App\Models\Sliders
 *
 * @property int $id
 * @property int $category_id
 * @property string $question_ar
 * @property string $question_en
 * @property string $answer_ar
 * @property string $answer_en
 * @property int $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Category[] $category
 * @property-read mixed $answer
 * @property-read mixed $question
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereAnswerAr($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereAnswerEn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereCategoryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereQuestionAr($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereQuestionEn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Candidates extends Model
{
    use CrudTrait;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];
    protected $table = 'candidates';
    protected $fillable = [
        'career_id', 'mobile', 'eduaction','cv'
    ];

}
