<?php

namespace App\Models;

use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Illuminate\Database\Eloquent\Model;
use App\Common;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

/**
 * App\Models\Sliders
 *
 * @property int $id
 * @property int $category_id
 * @property string $question_ar
 * @property string $question_en
 * @property string $answer_ar
 * @property string $answer_en
 * @property int $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Category[] $category
 * @property-read mixed $answer
 * @property-read mixed $question
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereAnswerAr($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereAnswerEn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereCategoryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereQuestionAr($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereQuestionEn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Careers extends Model
{
    use CrudTrait;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];
    protected $table = 'careers';
    protected $fillable = [
        'title', 'image', 'position', 'status','brief'
    ];
    public function setImageAttribute($value)
    {
          $attribute_name = "image";
        // or use your own disk, defined in config/filesystems.php
        $disk = config('backpack.base.root_disk_name');
        // destination path relative to the disk above
        $destination_path = "public/uploads/sliders";

        // if the image was erased
        if ($value == null) {
            // delete the image from disk
            \Storage::disk($disk)->delete($this->{$attribute_name});

            // set null in the database column
            $this->attributes[$attribute_name] = null;
        }

        // if a base64 was sent, store it in the db
        if (Str::startsWith($value, 'data:image')) {
            // 0. Make the image
            $image = \Image::make($value)->encode('jpg', 90);

            // 1. Generate a filename.
            $filename = md5($value . time()) . '.jpg';

            // 2. Store the image on disk.
            \Storage::disk($disk)->put($destination_path . '/' . $filename, $image->stream());
             // 3. Delete the previous image, if there was one.
            \Storage::disk($disk)->delete($this->{$attribute_name});

            // 4. Save the public path to the database
            // but first, remove "public/" from the path, since we're pointing to it
            // from the root folder; that way, what gets saved in the db
            // is the public URL (everything that comes after the domain name)
            $public_destination_path = Str::replaceFirst('public/', '', $destination_path);
            $this->attributes[$attribute_name] = $public_destination_path . '/' . $filename;
        } else {
            return $this->attributes[$attribute_name] = $value;
        }
    }

}
