<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use App\Common;
use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Faq
 *
 * @property int $id
 * @property string $question
 * @property string $answer
 * @property int $is_active
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 * @package App\Models
 */
class Complaints extends Model
{
    use CrudTrait;
	protected $table = 'complaints';


	protected $appends=['name'];
	protected $fillable = [
		'name_ar',
		'name_en'
	];
    public function getNameAttribute()
    {
        return Common::nameLanguage($this->name_en, $this->name_ar);
    }
}
