<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use App\Common;
use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Faq
 *
 * @property int $id
 * @property string $question
 * @property string $answer
 * @property int $is_active
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 * @package App\Models
 */
class ContactusRequests extends Model
{
    use CrudTrait;
	protected $table = 'contactus_requests';


	protected $fillable = [
        'type',
        'name',
        'position',
        'company',
        'enquires',
        'address',
        'message',
        'mobile',
        'inner_name',
        'inner_company',
        'facts',
        'communicated_facts',
        'files',
        'eduaction',
        'email',
        'compaints_affects',
        'address',
        'drug_batch_num',
        'gender',
        'occupation',
        'reported_drug',
        'company_permission',
        'report_details',
        'product_name',
        'company_name',
        'date_last_dose',
        'case_severity',
        'department',
        'designation',
        'susp_name',
        'susp_department',
        'susp_mobile',
        'susp_email',
        'susp_designation',
        'wit_name',
        'wit_department',
        'wit_mobile',
        'wit_email',
        'wit_designation',
        'q1',
        'q2',
        'q3',
        'q4',
        'q5',
        'q6',
        'q7',
        'q8',
        'patient_name',
        '',

	];
    protected static function booted()
    {
        static::addGlobalScope('sort', function (Builder $builder) {
            $builder->OrderBy('id', 'DESC');
        });
    }
}
