<?php

namespace App\Models;
 use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Illuminate\Database\Eloquent\Model;
use App\Common;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;
 use Illuminate\Database\Eloquent\Builder;
/**
 * App\Models\Sliders
 *
 * @property int $id
 * @property int $category_id
 * @property string $question_ar
 * @property string $question_en
 * @property string $answer_ar
 * @property string $answer_en
 * @property int $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Category[] $category
 * @property-read mixed $answer
 * @property-read mixed $question
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereAnswerAr($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereAnswerEn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereCategoryId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereQuestionAr($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereQuestionEn($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\Sliders whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Divisions extends Model
{
    use CrudTrait;
use SoftDeletes;
    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];
    protected $table ='divisions';
    protected $appends = ['title','description','breif','short_description'];

    protected $fillable = [
        'title_en', 'title_ar','breif_en', 'breif_ar','short_description_en' ,'short_description_ar',  'image', 'status','link','description_en','description_ar','innerimage','banners','extra_data','breif','order'
    ];
    protected $casts = ['banners' => 'array'];
    protected static function booted()
    {
        static::addGlobalScope('sort', function (Builder $builder) {
            $builder->OrderBy('order', 'ASC');
        });
    }
    public function getTitleAttribute()
    {
        return Common::nameLanguage($this->title_en, $this->title_ar);
    }
    public function getBreifAttribute()
    {
        return Common::nameLanguage($this->breif_en, $this->breif_ar);
    }

    public function getShortDescriptionAttribute()
    {
        return Common::nameLanguage($this->short_description_en, $this->short_description_ar);
    }
    public function getDescriptionAttribute()
    {
        return Common::nameLanguage($this->description_en, $this->description_ar);
    }
    public function setImageAttribute($value)
    {
        $attribute_name = "image";
        // or use your own disk, defined in config/filesystems.php
        $disk = config('backpack.base.root_disk_name');
        // destination path relative to the disk above
        $destination_path = "public/uploads/sliders";

        // if the image was erased
        if ($value == null) {
            // delete the image from disk
            \Storage::disk($disk)->delete($this->{$attribute_name});

            // set null in the database column
            $this->attributes[$attribute_name] = null;
        }

        // if a base64 was sent, store it in the db
        if (Str::startsWith($value, 'data:image')) {
            // 0. Make the image
            $image = \Image::make($value)->encode('png', 90);

            // 1. Generate a filename.
            $filename = md5($value . time()) . '.png';

            // 2. Store the image on disk.
            \Storage::disk($disk)->put($destination_path . '/' . $filename, $image->stream());

            // 3. Delete the previous image, if there was one.
            \Storage::disk($disk)->delete($this->{$attribute_name});

            // 4. Save the public path to the database
            // but first, remove "public/" from the path, since we're pointing to it
            // from the root folder; that way, what gets saved in the db
            // is the public URL (everything that comes after the domain name)
            $public_destination_path = Str::replaceFirst('public/', '', $destination_path);
            $this->attributes[$attribute_name] = $public_destination_path . '/' . $filename;
        } else {
            return $this->attributes[$attribute_name] = $value;
        }
    }
    public function setInnerimageAttribute($value)
    {
        $attribute_name = "innerimage";
        // or use your own disk, defined in config/filesystems.php
        $disk = config('backpack.base.root_disk_name');
        // destination path relative to the disk above
        $destination_path = "public/uploads/sliders";

        // if the image was erased
        if ($value == null) {
            // delete the image from disk
            \Storage::disk($disk)->delete($this->{$attribute_name});

            // set null in the database column
            $this->attributes[$attribute_name] = null;
        }

        // if a base64 was sent, store it in the db
        if (Str::startsWith($value, 'data:image')) {
            // 0. Make the image
            $image = \Image::make($value)->encode('jpg', 90);

            // 1. Generate a filename.
            $filename = md5($value . time()) . '.jpg';

            // 2. Store the image on disk.
            \Storage::disk($disk)->put($destination_path . '/' . $filename, $image->stream());

            // 3. Delete the previous image, if there was one.
            \Storage::disk($disk)->delete($this->{$attribute_name});

            // 4. Save the public path to the database
            // but first, remove "public/" from the path, since we're pointing to it
            // from the root folder; that way, what gets saved in the db
            // is the public URL (everything that comes after the domain name)
            $public_destination_path = Str::replaceFirst('public/', '', $destination_path);
            $this->attributes[$attribute_name] = $public_destination_path . '/' . $filename;
        } else {
            return $this->attributes[$attribute_name] = $value;
        }
    }


    public function uploadMultipleFilesToDisk($value, $attribute_name, $disk, $destination_path)
    {
        $request = \Request::instance();
        $attribute_value = (array) $this->{$attribute_name};
        $files_to_clear = $request->get('clear_'.$attribute_name);
         // if a file has been marked for removal,
        // delete it from the disk and from the db

        // if a new file is uploaded, store it on disk and its filename in the database
        if ($request->hasFile($attribute_name)) {
            foreach ($request->file($attribute_name) as $file) {
                if ($file->isValid()) {
                    // 1. Generate a new file name
                    $new_file_name = $file->getClientOriginalName();
                    // 2. Move the new file to the correct path
                    $file_path = $file->storeAs($destination_path, $new_file_name, $disk);
                    // 3. Add the public path to the database
                    $attribute_value[] = $file_path;
                }
            }
        }
        if ($files_to_clear) {
            $attribute_value_del = (array) $this->{$attribute_name};
            foreach ($files_to_clear as $key => $filename) {
                \Storage::disk($disk)->delete($filename);
                 if (in_array($filename, $attribute_value)) {
                     $index = array_search($filename,$attribute_value);

                     unset($attribute_value[$index]);
//                    $attribute_value = array_where($attribute_value, function ($value, $key) use ($filename) {
//                        return $value != $filename;
//                    });
                }
            }
        }
        $this->attributes[$attribute_name] = json_encode($attribute_value);
    }


    public function setBannersAttribute($value)
    {
        $attribute_name = "banners";
        // or use your own disk, defined in config/filesystems.php
        $disk = config('backpack.base.root_disk_name');
        // destination path relative to the disk above
        $destination_path = "public/uploads/sliders";

        $this->uploadMultipleFilesToDisk($value, $attribute_name, $disk, $destination_path);
    }
}
