<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Asciisd\Knet\HasKnet;

/**
 * Class Customer
 *
 * @property int $id

 * @property string|null $username
 * @property string $full_name
 * @property string|null $password
 * @property string|null $civil_id
 * @property int|null $country
 * @property int $phone
 * @property string|null $remember_token
 * @property bool $active
 * @property Carbon $created_at
 * @property Carbon $updated_at
 * @property string|null $deleted_at
 *
 * @property Collection|KnetTransactions2[] $knet_transactions2s
 *
 * @package App\Models
 */
class Status extends Model
{

    use CrudTrait;

    protected $table = 'status';

    protected $fillable = [
        'title_en',
        'title_ar'

    ];



}
