<?php

namespace App\Providers;

 use App\Models\Divisions;
 use App\Models\Setting;
 use App\Models\Settings;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function boot()
    {
                    $this->app['request']->server->set('HTTP', true);
         $this->sharedViews();
        Schema::defaultStringLength (191);
    }
    public function register()
    {
        $this->app->singleton('setting', function () {
            return Setting::first();
        });
        $this->app->singleton('expertises', function () {
            return Divisions::where('status',1)->get();
        });

        $this->app->singleton('settingsemail', function () {
            return  Settings::whereId(1)->first();
        });
        $this->app->singleton('settingslocation', function () {
            return  Settings::whereId(10)->first();
        });
        $this->app->singleton('settingslocationar', function () {
            return  Settings::whereId(17)->first();
        });
        $this->app->singleton('settingsphone', function () {
            return  Settings::whereId(13)->first();
        });
        $this->app->singleton('settingsmap', function () {
            return  Settings::whereId(16)->first();
        });


    }

    public function sharedViews()
    {
        View::share([
            'setting' => app('setting'),
            'expertises' => app('expertises'),
            'settingsemail' => app('settingsemail'),
            'settingslocation' => app('settingslocation'),
            'settingslocationar' => app('settingslocationar'),
            'settingsphone' => app('settingsphone'),
            'settingsmap' => app('settingsmap'),
            'lang' =>  app()->getLocale()

        ]);
    }
}
