<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactUsRequests extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contactus_requests', function (Blueprint $table) {
            $table->increments('id');
            $table->string('type')->nullable();
            $table->string('name')->nullable();
            $table->string('position')->nullable();
            $table->string('company')->nullable();
            $table->string('enquires')->nullable();
            $table->string('complaints')->nullable();
            $table->string('message')->nullable();


            $table->string('mobile')->nullable();
            $table->string('inner_name')->nullable();
            $table->string('inner_company')->nullable();
            $table->string('facts')->nullable();
            $table->string('communicated_facts')->nullable();
            $table->string('files')->nullable();
            $table->string('compaints_affects')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('contactus_requests', function (Blueprint $table) {
            //
        });
    }
}
