'use strict';(function(){var GoogleMap=(function(){function getAttr(element,data){var value=element.getAttribute('data-'+data);if(value==='true'){return true;}else if(value==='false'){return false;}
return value;}
function GoogleMapConstructor(container){this.container=container;this.markers=[];this.bounds=new google.maps.LatLngBounds();this.settings={zoom:parseInt(getAttr(container,'zoom')),styles:JSON.parse(getAttr(container,'style')||false),zoomControl:getAttr(container,'zoom-control'),streetViewControl:getAttr(container,'street-view-control'),rotateControl:getAttr(container,'rotate-control'),scaleControl:getAttr(container,'scale-control'),fullscreenControl:getAttr(container,'fullscreen-control'),panControl:getAttr(container,'pan-control'),disableDoubleClickZoom:getAttr(container,'double-click-zoom')===false,draggable:getAttr(container,'draggable'),keyboardShortcuts:getAttr(container,'keyboard-shortcuts'),scrollwheel:getAttr(container,'scrollwheel'),mapTypeId:google.maps.MapTypeId[getAttr(container,'map-type-control')],center:{lat:parseFloat(getAttr(container,'lat'))||0,lng:parseFloat(getAttr(container,'lng'))||0}};var mapContainer=container.getElementsByClassName('js-djangocms-googlemap-container');var markers=container.getElementsByClassName('js-djangocms-googlemap-marker');var routes=container.getElementsByClassName('js-djangocms-googlemap-route');markers=[].slice.call(markers);routes=[].slice.call(routes);this.map=new google.maps.Map(mapContainer[0],this.settings);var that=this;google.maps.event.addListenerOnce(this.map,'idle',function(){if(markers.length){that.addMarkers(markers);}
if(routes.length){that.addRoutes(routes);}});}
GoogleMapConstructor.prototype={addMarkers:function addMarkers(markers){var list=markers.map(function(marker){return{admin:getAttr(marker,'admin'),title:getAttr(marker,'title'),address:getAttr(marker,'address'),lat:getAttr(marker,'lat'),lng:getAttr(marker,'lng'),icon:getAttr(marker,'icon'),showContent:getAttr(marker,'show-content'),content:marker.innerHTML,animation:google.maps.Animation.DROP}},this);list.forEach(function(marker){this.addMarker(marker);},this);},addMarker:function addMarker(marker){var that=this;var latLng={lat:parseFloat(marker.lat),lng:parseFloat(marker.lng)};var geocoder=new google.maps.Geocoder();var pin;var coords;if(!latLng.lat||!latLng.lng){geocoder.geocode({address:marker.address},function(results,status){if(status===google.maps.GeocoderStatus.OK){coords=results[0].geometry.location;marker.lat=coords.lat();marker.lng=coords.lng();that.addMarker(marker);}});}else{marker.position=latLng;marker.map=this.map;pin=new google.maps.Marker(marker);pin.setMap(this.map);this.markers.push(pin);this.bounds.extend(pin.position);this._addInfoWindow(pin);this._addEditing(pin);}
if(this.map){this.update();}},update:function update(){google.maps.event.addListenerOnce(this.map,'bounds_changed',function(){if(this.map.getZoom()>this.settings.zoom){this.map.setZoom(this.settings.zoom);}}.bind(this));this.map.fitBounds(this.bounds);},addRoutes:function addRoutes(routes){routes.forEach(function(route){this.addRoute(route);},this);},addRoute:function addRoute(route){var that=this;var el='js-djangocms-googlemap-direction';var directions=route.getElementsByClassName(el);var title=getAttr(route,'title');var request={origin:getAttr(route,'origin'),destination:getAttr(route,'destination'),travelMode:getAttr(route,'travel-mode')};this.directionsDisplay=new google.maps.DirectionsRenderer();this.directionsService=new google.maps.DirectionsService();this.directionsDisplay.setPanel(directions[0]);this.directionsDisplay.setMap(this.map);if(!request.origin&&'geolocation'in navigator){navigator.geolocation.getCurrentPosition(function(position){request.origin=position.coords.latitude+','+position.coords.longitude;that.setDirection(request);});}else{that.setDirection(request);}},setDirection:function setDirection(request){var that=this;this.directionsService.route(request,function(result,status){if(status==='OK'){that.directionsDisplay.setDirections(result);}});},_addInfoWindow:function _addInfoWindow(marker){if(marker.content.trim()===''){return false;}
var that=this;var infoWindow=new google.maps.InfoWindow({disableAutoPan:true,content:marker.content});google.maps.event.addListener(marker,'click',function(){infoWindow.open(that.map,marker);marker.setAnimation(google.maps.Animation.BOUNCE);setTimeout(function(){marker.setAnimation(null);},750);});if(marker.showContent){infoWindow.open(this.map,marker);}},_addEditing:function _addEditing(marker){if(window.CMS&&window.CMS.Modal){google.maps.event.addListener(marker,'dblclick',function(e){if(!e.xa){return false;}
e.xa.stopPropagation();var modal=new CMS.Modal();modal.open({url:marker.admin});});}}};return GoogleMapConstructor;})();window.addEventListener('load',function(){var elements=document.getElementsByClassName('js-djangocms-googlemap');elements=[].slice.call(elements);elements.forEach(function(element){new GoogleMap(element);},this);});})();