<?php
// Function to read links from a text file
function readLinks($filename) {
    if (!file_exists($filename)) {
        die("Error: The file '$filename' does not exist.");
    }

    $links = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    if ($links === false) {
        die("Error: Unable to read links from '$filename'.");
    }

    return $links;
}

// Function to select a random link
function getRandomLink($links) {
    if (empty($links)) {
        die("Error: No links found in the file.");
    }

    $randomIndex = array_rand($links);
    return $links[$randomIndex];
}

// File containing links
$filename = 'links.txt';

// Read links from the file
$links = readLinks($filename);

// Get a random link
$randomLink = getRandomLink($links);

// Redirect to the random link
header("Location: $randomLink");
exit;
?>
