@extends('layouts.innerapp')
@section('content')

    <div class="news-bnr">
        <img src="{{asset($banner->image)}}" alt="" class="img-fluid news-bnr_img">
        <div class="news-bnr_overlay"></div>
        <div class="container-xl">
            <p class="news-bnr_title">@lang('website.news_events_label')</p>
        </div>
    </div>




    <div class="news-crumb">
        <div class="container-xl">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pl-0">
                            <li class="breadcrumb-item"><a href="/">@lang("website.home_label")</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><a href="{{route('news')}}">@lang('website.news_events_label')</a>
                            </li>
                            <li class="breadcrumb-item"><a href="/">All</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    
    
    
    

    <div class="newsCategory">
        <div class="container-xl">
             <div class="yearsList">
                <ul>
                    <a href="{{route('AllNews')}}"><li class="active">All</li></a>
                    <a href="{{route('news2024')}}"><li >2024</li></a>
                </ul>
            </div>

        </div><!--container-->
    </div><!--newsCategory-->

        <div class="container-xl">
            <div class="row">
                @foreach($news as $key=>$new)
                <div class="col-md-4">
                <a href="{{route('newsDetails' , $new -> id)}}"><div class="newsBox">
                        <img src="{{asset('images/events/'.$new->image)}}">
                        <div class="newsboxContent">
                               <h5 class="card-title">{{$new->title}}</h5>
                                <ul class="date-time">
                                    <li><img src="{{asset('images/calender.png')}}" alt=""><span>{{\Carbon\Carbon::Parse($new->created_at)->format('y-m-d')}}</span></li>
                                    <li><img src="{{asset('images/time.png')}}" alt=""><span>{{\Carbon\Carbon::Parse($new->created_at)->format('H:i')}}</span></li>
                                </ul>
                        </div>
                    </div></a><!--newzBox-->
                </div>
                @endforeach
            </div>
        </div>

    <div class="galary py-5">
        <div class="container-xl">
            <div class="row">
               <br />

            </div>
        </div>

    </div>


@endsection
