@extends('layouts.innerapp')
@section('content')

    <div class="contact-bnr">
        <img src="{{asset($banner->image)}}" alt="" class="img-fluid contact-bnr_img">
        <div class="contact-bnr_overlay"></div>
        <div class="container-xl">
            <p class="contact-bnr_title">@lang("website.c_us_labl")</p>
        </div>
    </div>

    <div class="contact-crumb">
        <div class="container-xl">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pl-0">
                            <li class="breadcrumb-item"><a href="/">@lang("website.home_label")</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><a href="{{route('contact-us')}}">@lang("website.c_us_labl")
                                </a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>



    <div class="serv-items">
        <div class="container-xl">
            <div class="row">
                {!! $page->description !!}
            </div>
        </div>
    </div>

    <div class="contact-forms py-4 py-md-5">
        <div class="container-xl">
            <div class="row flex-column">
                @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                        <li class="nav-item contacli" role="presentation">
                            <a class="nav-link  px-3" id="home-tab" href="{{route('contact-us')}}" role="tab"
                               aria-controls="home" aria-selected="true">@lang("website.Contact_Form")</a>
                        </li>
                        <li class="nav-item contacli" role="presentation">
                            <a class="nav-link px-3" id="profile-tab" href="{{route('pharmacovigilance')}}" role="tab"
                               aria-controls="profile" aria-selected="false">@lang("website.Pharmacovigilance")</a>
                        </li>
                        <li class="nav-item contacli" role="presentation">
                            <a class="nav-link px-3" id="profile-tab" href="{{route('quality')}}" role="tab"
                               aria-controls="profile" aria-selected="false">@lang("website.quailty_assurance")</a>
                        </li>
                        <li class="nav-item contacli" role="presentation">
                            <a class="nav-link px-3 active" id="profile-tab" href="{{route('compliance')}}" role="tab"
                               aria-controls="profile" aria-selected="false">@lang("website.Compliance")</a>
                        </li>
                        <li class="nav-item contacli" role="presentation">
                            <a class="nav-link px-3 " id="profile-tab" href="{{route('security')}}" role="tab"
                               aria-controls="profile" aria-selected="false">@lang("website.Cyber_security")</a>
                        </li>
                    </ul>
                    <div class="tab-content" id="myTabContent">

                    <div class="tab-pane fade show active px-3 px-md-5" id="complianceForm" role="tabpanel"
                         aria-labelledby="home-tab">

                        <div class="cont-form">
                            <p class="title">@lang("website.Compliance_msg")</p>

                            <form action="{{route('postcompliance')}}" enctype="multipart/form-data" method="post">
                                @csrf
                                <input type="hidden" name="type" value="compliance">

                                <div class="form-row">
                                    <div class="form-group col-md-4">
                                        <input type="text" name="name" class="form-control" placeholder="@lang('website.Name')">
                                    </div>
                                    <div class="form-group col-md-4">
                                        <input type="text" name="mobile" class="form-control" placeholder="@lang('website.Contact_Num')">
                                    </div>
                                    <div class="form-group col-md-4">
                                        <input type="text" name="email" class="form-control" placeholder="@lang('website.email_req')">
                                    </div>



                                    <div class="form-group col-md-4">
                                        <select id="inputState" name="designation" class="form-control">
                                            <option value="Dr">@lang('website.Dr')</option>
                                            <option value="Pharmacist">@lang('website.Pharmacist')</option>
                                            <option value="Ms Mrs">@lang('website.Ms Mrs')</option>
                                            <option value="Mr">@lang('website.Mr')</option>
                                        </select>
                                    </div>
                                </div>
                                <p class="title">@lang('website.SUSPECT’S INFORMATION')</p>

                                <div class="form-row">
                                    <div class="form-group col-md-4">
                                        <input type="text" name="susp_name" class="form-control" placeholder="@lang('website.Name')">
                                    </div>

                                    <div class="form-group col-md-4">
                                        <input type="text" name="susp_mobile" class="form-control" placeholder="@lang('website.Mobile')">
                                    </div>
                                    <div class="form-group col-md-4">
                                        <input type="text" name="susp_email" class="form-control" placeholder="@lang('website.email_req')">
                                    </div>

                                    <div class="form-group col-md-4">
                                        <select id="inputState" name="susp_designation" class="form-control">
                                            <option value="Dr">@lang('website.Dr')</option>
                                            <option value="Pharmacist">@lang('website.Pharmacist')</option>
                                            <option value="Ms Mrs">@lang('website.Ms Mrs')</option>
                                            <option value="Mr">@lang('website.Mr')</option>
                                        </select>
                                    </div></div>
                                <p class="title">@lang('website.COMPLAINT')</p>

                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <input type="text" name="q1" class="form-control" placeholder="@lang('website.q1') ">
                                    </div>
                                    {{--                                    <div class="form-group col-md-12">--}}
                                    {{--                                        <input type="text" name="q2" class="form-control" placeholder="@lang('website.q2') ">--}}
                                    {{--                                    </div>--}}
                                    <div class="form-group col-md-12">
                                        <input type="text" name="q3" class="form-control" placeholder="@lang('website.q3') ">
                                    </div>
                                    <div class="form-group col-md-12">
                                        <input type="text" name="q4" class="form-control" placeholder="@lang('website.q4') ">
                                    </div>
                                    <div class="form-group col-md-12">
                                        <input type="text" name="q5" class="form-control" placeholder="@lang('website.q5') ">
                                    </div>
                                    <div class="form-group col-md-12">
                                        <input type="text" name="q6" class="form-control" placeholder="@lang('website.q6') ">
                                    </div>
                                    <div class="form-group col-md-12">
                                        <input type="text" name="q7" class="form-control" placeholder="@lang('website.q7') ">
                                    </div>
                                    <div class="form-group col-md-12">
                                        <input type="text" name="q8" class="form-control" placeholder="@lang('website.q8') ">
                                    </div>

                                </div>

                                <div class="form-row" style="margin: 0 0 10px 0;">
                                    {!!  captcha_img() !!}
                                    <input type="text" name="captcha" class="form-control col-md-4" style="margin: 0 5px 0px 9px;" placeholder="@lang('website.captcha') ">

                                </div>


                                <div class="text-center"><button type="submit"
                                                                 class="btn btn-primary px-5 py-2 mt-2">@lang('website.submit_label')</button></div>
                            </form>
                        </div>

                    </div>

                </div>
            </div>
        </div>

    </div>

@endsection
