@extends('layouts.innerapp')
@section('content')


    <div class="division-bnr">
        <img src="{{asset($banner->image)}}" alt="" class="img-fluid division-bnr_img">
        <div class="division-bnr_overlay"></div>
        <div class="container-xl">
            <p class="division-bnr_title">@lang('website.Divisions_label')</p>
        </div>
    </div>

    <div class="division-crumb">
        <div class="container-xl">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pl-0">
                            <li class="breadcrumb-item"><a href="/">@lang("website.home_label")</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><a
                                    href="{{route('division')}}">@lang('website.Divisions_label')</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="divi-items mt-2 mt-md-5 pb-5">
        <div class="container-xl">
            <div>
                @foreach($divisions as $division)
                <div id="{{$division->id}}" class="divi-item mb-5 d-flex flex-column flex-md-row">
                    <img src="{{ asset($division->innerimage) }}" alt="" class="main-img img-fluid">
                    <div class="divi-content d-flex flex-column align-items-start">
                        <h5 class="divi-item_head">{{ $division->title }}</h5>
                        <p class="divi-item_title">{{ $division->breif }}</p>
                        @if($division->id == 6)
                            <p class="divi-item_desc">{!!  $division->short_description  !!}</p>
                            @else
                        <p class="divi-item_desc">{!! $division->short_description !!}</p>
                        @endif
                        @if(($division->banners))
                        <div class="swiper mySwiper mt-3">
                            <div class="swiper-wrapper">
{{--                                @foreach($division->banners as $banner)--}}
{{--                                    <div class="swiper-slide"><img src="{{ str_replace('public','',$banner) }}" alt=""></div>--}}
{{--                                @endforeach--}}


                            </div>
{{--                            <div class="swiper-button-next"></div>--}}
{{--                            <div class="swiper-button-prev"></div>--}}

                        </div>
                        @endif
                         <div style="clear: both;height: 20px;"></div>




                        <a href="{{ route('divisiondetails',[$division->id]) }}#{{$division->id}}" class="division-more">{{__("website.see_more")}}<img src="./images/arrows.png" alt="" class="img-fluid"></a>

                    </div>
                </div>
                @endforeach

            </div>
        </div>
    </div>


@endsection
