@extends('layouts.innerapp')
@section('content')


    <div class="division-bnr">
        <img src="{{ asset($divisions->image) }}" alt="" class="img-fluid division-bnr_img">
        <div class="division-bnr_overlay"></div>
        <div class="container-xl">
            <p class="division-bnr_title">{{ $divisions->title }}</p>
        </div>
    </div>

    <div class="division-crumb">
        <div class="container-xl">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pl-0">
                            <li class="breadcrumb-item"><a href="/">@lang("website.home_label")</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><a
                                        href="{{route('division')}}">{{ $divisions->title }}</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="divi-items mt-2 mt-md-5 pb-5">
        <div class="container-xl">
            <div class="row ">
                <div class="col-12">
{{--                    <h2 class="about-title">{{ $divisions->title }}</h2>--}}
                    <p class="about-desc">{!! $divisions->description !!}</p>
                    <br />
                    @if(($divisions->banners))
                        <div class="row">
                                 @foreach($divisions->banners as $banner)
                                    <div class="col-xs-6 col-sm-6 col-md-6 col-lg-3" style="margin: 4% 0 0 0px;">
                                        <div class="logoDiv">
                                        <img style="width: 100%;" src="{{ str_replace('public','',$banner) }}" alt=""></div></div>
                                @endforeach



                        </div>
                    @endif
                    <br />
                    <center>
                    {!! $divisions->extra_data !!}</center>
                </div>
            </div>
        </div>
    </div>


@endsection
