@extends('layouts.innerapp')
@section('content')

    <div class="news-bnr">
        <img src="{{asset($banner->image)}}" alt="" class="img-fluid news-bnr_img">
        <div class="news-bnr_overlay"></div>
        <div class="container-xl">
            <p class="news-bnr_title">@lang('website.news_events_label')</p>
        </div>
    </div>




    <div class="news-crumb">
        <div class="container-xl">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pl-0">
                            <li class="breadcrumb-item"><a href="/">@lang("website.home_label")</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><a href="{{route('news')}}">@lang('website.news_events_label')</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    
    
    
    
    




    
    

    <div class="newsCategory">
        <div class="container-xl">
            <div class="yearsList">
               <!-- Nav tabs -->
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                  <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">All</button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">2024</button>
                  </li>
                  <li class="nav-item" role="presentation">
                    <button class="nav-link" id="messages-tab" data-bs-toggle="tab" data-bs-target="#messages" type="button" role="tab" aria-controls="messages" aria-selected="false">2025</button>
                  </li>
                </ul>
                
                <!-- Tab panes -->
            </div>
        </div><!--container-->
    </div><!--newsCategory-->

    <div class="">
        <div class="container-xl">
            <div class="tab-content">
                  
                  <div class="tab-pane active" id="home" role="tabpanel" aria-labelledby="home-tab">
                    <div class="row">
                        @foreach($news as $key=>$new)
                        <div class="col-md-4">
                             <a href="{{route('newsDetails' , $new -> id)}}"><div class="newsBox">
                                <img src="{{asset('images/events/'.$new->image)}}">
                                <div class="newsboxContent">
                                       <h5 class="card-title">{{$new->title}}</h5>
                                        <ul class="date-time">
                                            <li><img src="images/calender.png" alt=""><span>{{\Carbon\Carbon::Parse($new->created_at)->format('y-m-d')}}</span></li>
                                            <li><img src="images/time.png" alt=""><span>{{\Carbon\Carbon::Parse($new->created_at)->format('H:i')}}</span></li>
                                        </ul>
                                </div>
                            </div></a>
                        </div>
                        @endforeach
                    </div>
                 </div><!--all tab-->
                 <div class="tab-pane" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                      <div class="row">
                        @foreach($news as $key=>$new)
                        @if ($new->date == '2024')
                        <div class="col-md-4">
                             <a href="{{route('newsDetails' , $new -> id)}}"><div class="newsBox">
                                <img src="{{asset('images/events/'.$new->image)}}">
                                <div class="newsboxContent">
                                       <h5 class="card-title">{{$new->title}}</h5>
                                        <ul class="date-time">
                                            <li><img src="images/calender.png" alt=""><span>{{\Carbon\Carbon::Parse($new->created_at)->format('y-m-d')}}</span></li>
                                            <li><img src="images/time.png" alt=""><span>{{\Carbon\Carbon::Parse($new->created_at)->format('H:i')}}</span></li>
                                        </ul>
                                </div>
                            </div></a>
                        </div>
                        @else
                        @endif
                        @endforeach
                    </div>
                 </div>
                 <div class="tab-pane" id="messages" role="tabpanel" aria-labelledby="messages-tab">
                       <div class="row">
                        @foreach($news as $key=>$new)
                        @if ($new->date == '2025')
                        <div class="col-md-4">
                             <a href="{{route('newsDetails' , $new -> id)}}"><div class="newsBox">
                                <img src="{{asset('images/events/'.$new->image)}}">
                                <div class="newsboxContent">
                                       <h5 class="card-title">{{$new->title}}</h5>
                                        <ul class="date-time">
                                            <li><img src="images/calender.png" alt=""><span>{{\Carbon\Carbon::Parse($new->created_at)->format('y-m-d')}}</span></li>
                                            <li><img src="images/time.png" alt=""><span>{{\Carbon\Carbon::Parse($new->created_at)->format('H:i')}}</span></li>
                                        </ul>
                                </div>
                            </div></a>
                        </div>
                        @else
                        @endif
                        @endforeach
                    </div>
                 </div>
            </div><!--tab-content-->
        </div>


        </div>
    </div>





    <div class="galary py-5">
        <div class="container-xl">
            <div class="row">
               <br />

            </div>
        </div>

    </div>


@endsection
