@extends('layouts.innerapp')
@section('content')

    <div class="news-bnr">
        <img src="{{asset($banner->image)}}" alt="" class="img-fluid news-bnr_img">
        <div class="news-bnr_overlay"></div>
        <div class="container-xl">
            <p class="news-bnr_title">@lang('website.news_events_label')</p>
        </div>
    </div>




    <div class="news-crumb">
        <div class="container-xl">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pl-0">
                            <li class="breadcrumb-item"><a href="/">@lang("website.home_label")</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><a href="{{route('news')}}">@lang('website.news_events_label')</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>



    <div class="">
        <div class="container-xl">
                <div class="newsBox newsBoxInner">
                    <div class="row newsBoxInnerIn">
                        <div class="col-md-6">
                            <img src="{{asset('images/events/'.$news->image)}}">
                        </div>
                        <div class="col-md-6">
                            <div class="contentIn">
                                    <h5 class="card-title">{{$news->title}}</h5>
                                    <p class="">{{$news->description}}</p>
                                        <ul class="date-time">
                                            <li><img src="{{asset('images/calender.png')}}" alt=""><span>{{\Carbon\Carbon::Parse($news->created_at)->format('y-m-d')}}</span></li>
                                            <li><img src="{{asset('images/time.png')}}" alt=""><span>{{\Carbon\Carbon::Parse($news->created_at)->format('H:i')}}</span></li>
                                        </ul>
                            </div>
                        </div><!--col-md-6-->
                    </div>



                    @if($news->photo == null)

                    @else
                    <div class="col-md-12">
                        <div class="row allEventsPhoto" >
                                @php
                                    $photo = DB::table('news')->where('id', $news->id)->select('photo')->get();
                                @endphp
                                @if (count(['photo']))
                                @foreach  (explode('|',$photo[0]->photo) as $item)
                                <div class="col-md-4">
                                        <a href="{{asset($item)}}"><img class="placeImgs" src="{{asset($item)}}"></a>
                                </div>

                                @endforeach
                                @endif
                        </div>
                    </div><!--col-md-12-->

                    @endif







                </div><!--newzBox-->

        </div>


        </div>
    </div>





    <div class="galary py-5">
        <div class="container-xl">
            <div class="row">
               <br />

            </div>
        </div>

    </div>


@endsection
