@extends('layouts.innerapp')
@section('content')

    <div class="serv-bnr">
        <img src="./images/services-bnr.jpg" alt="" class="img-fluid serv-bnr_img">
        <div class="serv-bnr_overlay"></div>
        <div class="container-xl">
            <p class="serv-bnr_title">@lang('website.Services')</p>
        </div>
    </div>

    <div class="serv-crumb">
        <div class="container-xl">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb pl-0">
                            <li class="breadcrumb-item"><a href="/">@lang("website.home_label")</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><a
                                    href="{{route('services')}}">@lang('website.Services')</a>
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <div class="serv-items">
        <div class="container-xl">
            <div class="row">
                @foreach($services as $service)
                <div class="col-12 col-md-6">
                    <div class="serv-item">
                        <img src="{{ asset($service->innerimage) }}" alt="" class="img-fluid">
                        <h3 class="serv-item_title">{{ $service->title }}</h3>
                        <div class="serv-item_desc">
                            {!! $service->description !!}
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>


@endsection
