@extends('layouts.app')
@section('content')

    <!-- Start Search -->
    <div class="Banner">
        <div class="">
            <div class="s r">
                <div id="slider" class="nivoSlider  theme-default">
                @foreach($banners as $banner)
                        <img src="{{ asset($banner->image) }}" data-thumb="{{ asset($banner->image) }}"  />


                @endforeach



                </div>

            </div>

        </div>

    </div>
    <div class="Banner-content">
        <form action="{{route('search')}}" method="post">
            @csrf
            <div class="form-group search-wrapper">
                <input type="text" name="search" placeholder="SEARCH HERE">
                <img src="./images/main-search-icon.png" alt="" class="img-fluid">
            </div>
        </form>
    </div>

    <!-- Start About US -->
    <div class="AboutUs">
         <img src="/images/header-last.jpg" alt="" class="img-fluid about-bg d-none d-md-block">
        <div class="container-xl About-content">
            <div class="row text-center">
                <div class="col-12">
                    <h2 class="about-title text-center">{{ $about->name }}</h2>
                    @if(\App::getLocale()=='en')
                    <p class="about-desc">{!! substr($about->description,0,300) !!}</p>
                    @else
                        <p class="about-desc">{!! substr($about->description,0,400) !!}</p>

                    @endif
                    <a href="{{ route('page',['about-us']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt="" class="img-fluid"></a>
                    <br />
                    <br />
                    <br />
                </div>
            </div>
        </div>


    </div>

    <!-- Start Mission -->
    <div class="mission">
        <div class="row mx-0">
            @if(\App::getLocale()=='en')
            <div class="col-12 col-md-6 px-md-0 d-flex">
                <div class="mission-content text-left">
                    <h2 class="mission-title">{{ $mission->name }}</h2>
                    <p class="mission-desc">{!! substr($mission->description,0,300) !!}</p>

                    <a href="{{ route('page',['mission']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                   class="img-fluid"></a>
                </div>
            </div>
            <div class="col-12 col-md-6 px-0">
                <img src="{{ asset($mission->image) }}" alt="" class="img-fluid mission-img">
            </div>

            @else
                <div class="col-12 col-md-6 px-0 hidephone">
                    <img src="{{ asset($mission->image) }}" alt="" class="img-fluid mission-img">
                </div>
                <div class="col-12 col-md-6 px-md-0 d-flex hidephone">
                    <div class="mission-content text-right">
                        <h2 class="mission-title">{{ $mission->name }}</h2>
                        <p class="mission-desc">{!! substr($mission->description,0,300) !!}</p>

                        <a href="{{ route('page',['mission']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                                                                       class="img-fluid"></a>
                    </div>
                </div>
                

                <div class="col-12 col-md-6 px-md-0 d-flex hideweb">
                    <div class="mission-content text-right">
                        <h2 class="mission-title">{{ $mission->name }}</h2>
                        <p class="mission-desc">{!! substr($mission->description,0,300) !!}</p>

                        <a href="{{ route('page',['mission']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                                                                       class="img-fluid"></a>
                    </div>
                </div>
                <div class="col-12 col-md-6 px-0 hideweb">
                    <img src="{{ asset($mission->image) }}" alt="" class="img-fluid mission-img">
                </div>
                
            @endif
        </div>
    </div>

    <!-- Start Vission -->
    <div class="vission">
        <div class="row mx-0">
            @if(\App::getLocale()=='en')
            <div class="col-12 col-md-6 px-0 order-1 order-md-0">
                <img src="{{ asset($vission->image) }}" alt="" class="img-fluid mission-img">
            </div>
            <div class="col-12 col-md-6 px-md-0 d-flex order-0">
                <div class="mission-content text-left">
                    <h2 class="mission-title">{{ $vission->name }}</h2>
                    <p class="mission-desc">{!! substr($vission->description,0,300) !!}</p>
                    <a href="{{ route('page',['vission']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                   class="img-fluid"></a>
                </div>
            </div>
                @else
                
                <div class="col-12 col-md-6 px-md-0 d-flex   hidephone">
                    <div class="mission-content text-right">
                        <h2 class="mission-title">{{ $vission->name }}</h2>
                        <p class="mission-desc">{!! substr($vission->description,0,300) !!}</p>
                        <a href="{{ route('page',['vission']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                                                                       class="img-fluid"></a>
                    </div>
                </div>
                <div class="col-12 col-md-6 px-0  order-md-0 hidephone">
                    <img src="{{ asset($vission->image) }}" alt="" class="img-fluid mission-img">
                </div>
                
                
                
                 <div class="col-12 col-md-6 px-0 order-1 order-md-0 hideweb">
                    <img src="{{ asset($vission->image) }}" alt="" class="img-fluid mission-img">
                </div>
                                <div class="col-12 col-md-6 px-md-0 d-flex order-0 hideweb">
                    <div class="mission-content text-right">
                        <h2 class="mission-title">{{ $vission->name }}</h2>
                        <p class="mission-desc">{!! substr($vission->description,0,300) !!}</p>
                        <a href="{{ route('page',['vission']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                                                                       class="img-fluid"></a>
                    </div>
                </div>
               
            @endif
        </div>
    </div>

    <!-- Start History -->
    <div class="history">
        <div class="row mx-0">
            @if(\App::getLocale()=='en')
            <div class="col-12 col-md-6 px-md-0 d-flex ">
                <div class="mission-content text-left">
                    <h2 class="mission-title">{{ $history->name }}</h2>
                    <p class="mission-desc">{!! substr($history->description,0,300) !!}</p>
                    <a href="{{ route('page',['history']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                   class="img-fluid"></a>
                </div>
            </div>
            <div class="col-12 col-md-6 px-0">
                <img src="{{ asset($history->image) }}" alt="" class="img-fluid mission-img">
            </div>
                @else
                <div class="col-12 col-md-6 px-0 hidephone">
                    <img src="{{ asset($history->image) }}" alt="" class="img-fluid mission-img">
                </div>
                <div class="col-12 col-md-6 px-md-0 d-flex hidephone" >
                    <div class="mission-content text-right">
                        <h2 class="mission-title">{{ $history->name }}</h2>
                        <p class="mission-desc">{!! substr($history->description,0,299) !!}</p>
                        <a href="{{ route('page',['history']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                                                                       class="img-fluid"></a>
                    </div>
                </div>
                
                
                       
                <div class="col-12 col-md-6 px-md-0 d-flex hideweb">
                    <div class="mission-content text-right">
                        <h2 class="mission-title">{{ $history->name }}</h2>
                        <p class="mission-desc">{!! substr($history->description,0,299) !!}</p>
                        <a href="{{ route('page',['history']) }}" class="mission-more">{{__("website.see_more")}} <img src="./images/arrows.png" alt=""
                                                                                                                       class="img-fluid"></a>
                    </div>
                </div>
                     <div class="col-12 col-md-6 px-0 hideweb">
                    <img src="{{ asset($history->image) }}" alt="" class="img-fluid mission-img">
                </div>
            @endif
        </div>
    </div>

    <!-- Start Services -->
    <div class="services">
        <img src="./images/services.jpg" alt="" class="img-fluid d-none d-md-block services-bg">
        <div class="services-overlay d-none d-md-block"></div>
        <div class="container-xl services-content">
            <h2 class="services-title text-center">{{__("website.Services")}}</h2>

            <div class="row">
                @foreach($services as $service)

                <div class="col-6 col-sm-4">
                    <div class="service">  <a href="{{ route('services')  }}">
                        <div class="ser-img">
                            <img src="{{ asset($service->image) }}" alt="">
                        </div> </a>
                        <p class="ser-title">{{ $service->title }}</p>
                    </div>
                </div>

                @endforeach
            </div>
        </div>
    </div>

    <!-- Start Divisions -->
    <div class="divisions">
        <h2 class="divisions-title text-center">{{__("website.division_supp")}}</h2>
        <ul class="nav nav-tabs divisions-tabs" id="myTab" role="tablist">
        @foreach($divisions as $division)
            <li class="nav-item" role="presentation">
                <a class="nav-link @if ($loop->first) active @endif" id="home-tab" data-toggle="tab" href="#{{ str_replace(' ','',$division->title) }}" role="tab" aria-controls="{{ str_replace(' ','',$division->title) }}"
                   aria-selected="@if ($loop->first) true @else false @endif">{{ $division->title }}</a>
            </li>
            @endforeach
        </ul>
        <div class="tab-content" id="myTabContent">
            @foreach($divisions as $division)

            <div class="tab-pane fade   @if ($loop->first) show active @endif" id="{{ str_replace(' ','',$division->title) }}" role="tabpanel" aria-labelledby="{{ str_replace(' ','',$division->title) }}-tab">
                <div class="division-content">
                    <img src="{{ asset($division->image) }}" alt="" class="img-fluid d-none d-sm-block division-content-bg-dsk">
                    <img src="{{ asset($division->image) }}" alt="" class="img-fluid bnr-bg d-sm-none division-content-bg-mbl">
                    <div class="division-desc" style="color: white;">
                        <h2 class="div-content-title">{{ $division->title }}</h2>
                        <p class="div-content-desc"><p>{!! substr($division->short_description,0,600) !!}</p>
                        </p>
                        <a href="{{ route('division') }}#{{$division->id}}" class="division-more">{{__("website.see_more")}}<img src="./images/arrows.png" alt=""
                                                                        class="img-fluid"></a>
                    </div>
                    <div class="division-overlay"></div>
                </div>
            </div>
            @endforeach

        </div>
    </div>
    @if(in_array(\Request::route()->getName(),['contact-us']))

    <!-- Start Contact US -->
    <div class=" ContactUs text-center py-5">
        <div class="container-xl ">
            <p class="contact-title-1 text-center">{{__("website.reliable_partner")}}</p>
            <h2 class="contact-tilte-2 text-center">{{__("website.contact_us_label")}}</h2>
            <div class="contact-details mt-5 ">
                @if(\App::getLocale()=='en')
                <p ><img src="/images/location.png" class="img-fluid"> {{ $settingslocation->value }}</p>
                    <p ><img src="/images/e-mail.png" class="img-fluid">{{ $settingsemail->value }}</p>
                    <p ><img src="/images/fax.png" class="img-fluid"> {{ $settingsphone->value }}</p>
                @else
                <p ><img src="/images/location.png" class="img-fluid"> {{ $settingslocationar->value }}</p>
                    <p ><img src="/images/e-mail.png" class="img-fluid">&nbsp;{{ $settingsemail->value }}</p>
                    <p  dir="ltr"> {{ $settingsphone->value }}&nbsp;<img src="/images/fax.png" class="img-fluid"></p>
                @endif

            </div>

            <div style="clear:both;"></div>
            
        </div>
    </div>
        @else
        <footer>
            <div class="container-xl">
                <div class="row pt-3 text-center">
                    <center>
                        <div class="col-12 col-sm-12 text-sm-left">

                            <a  class="footLink contact" href="{{ route('page',['about-us'])  }}"  >
                                @lang("website.about_us_label")
                            </a>
                            <a  class="footLink contact" href="{{ route('page',['mission']) }}"> @lang("website.mission_label")</a>
                            <a  class="footLink contact" href="{{ route('page',['vission']) }}"> @lang("website.vision_label")</a>
                            <a  class="footLink contact" href="{{ route('page',['history']) }}"> @lang("website.history_label")</a>
                        </div>
                    </center>
                </div>
            </div>
        </footer>
    @endif

    <!-- Start Footer -->

@endsection
