@extends(backpack_view('layouts.top_left_data'))



@section('content')


    @if(Session::has('successEdit'))
        <div class="alert alert-success" role="alert">
            Edit successfully
        </div>
    @endif

    <nav aria-label="breadcrumb" class="d-none d-lg-block">
	    <ol class="breadcrumb bg-transparent p-0 justify-content-end">
            <li class="breadcrumb-item text-capitalize"><a href="{{ backpack_url('dashboard') }}">Admin</a></li>
            <li class="breadcrumb-item text-capitalize"><a href="{{route('events')}}">Edit Events</a></li>
            <li class="breadcrumb-item text-capitalize active" aria-current="page">List</li>
        </ol>
	</nav>


    <div class="card">
        <div class="card-body">
            <form method="post"  action="{{Route('events.update', $news -> id)}}" enctype="multipart/form-data">
            @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="">Title Ar</label>
                            <input type="text" name="title_ar" value="{{$news -> title_ar}}" class="form-control" required>
                        </div>
                    </div><!--col-md-4-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="">Title En</label>
                            <input type="text" name="title_en" value="{{$news -> title_en}}" class="form-control" required>
                        </div>
                    </div><!--col-md-4-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="">Description Ar</label>
                            <textarea name="description_ar" class="form-control" required>{{$news -> description_ar}}</textarea>
                        </div>
                    </div><!--col-md-4-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="">Description En</label>
                            <textarea name="description_en" class="form-control" required>{{$news -> description_en}}</textarea>
                        </div>
                    </div><!--col-md-4-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="">Main image</label>
                            <input type="file" name="image" class="form-control" required>
                        </div>
                    </div><!--col-md-4-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="">Event image</label>
                            <input type="file" name="photo[]" class="form-control" multiple>
                        </div>
                    </div><!--col-md-4-->
                    <div class="col-md-6" style=" visibility: hidden;">
                        <div class="form-group">
                            <label for="">Date</label>
                            <input type="text" name="date" value="{{$news -> date}}" value="2024" class="form-control" readonly>
                        </div>
                    </div><!--col-md-4-->
                </div>
                <div class="d-print-none with-border">
                    <button type="submit" class="btn btn-primary" >Submit</button>
                    <a href="{{route('events')}}"><button type="button" class="btn btn-success" >All events</button></a>
                </div>
            </form>
        </div>
    </div>









<style>
    div.dataTables_wrapper div.dataTables_filter label{
        display: block !important;
    }

    div.dataTables_wrapper div.dataTables_info{
        display: none !important;
    }

    div.dataTables_wrapper div.dataTables_length label {
        font-weight: normal;
        text-align: left;
        white-space: nowrap;
        display: block;
        position: absolute;
        right: 42px;
        margin-top: -18px;
    }


    .dt-buttons{

    }


    .dt-buttons .btn-group, .btn-group-vertical {
        display: inline-flex;
        position: relative;
        vertical-align: middle;
        position: absolute;
        right: 32%;
    }

    div.dataTables_wrapper div.dataTables_paginate{
        margin: auto;
    }

    .paginate_button  a{
        padding: 15px;

    }

    .buttons-colvis{
        display: none;
    }

    div.dataTables_wrapper div.dataTables_paginate ul.pagination {
        margin: 20px 0;
    }
</style>


@endsection
