<?php

use Illuminate\Support\Facades\Route;

// --------------------------
// Custom Backpack Routes
// --------------------------
// This route file is loaded automatically by Backpack\Base.
// Routes you generate using Backpack\Generators will be placed here.

Route::group([
    'prefix'     => config('backpack.base.route_prefix', 'admin'),
    'middleware' => array_merge(
        (array) config('backpack.base.web_middleware', 'web'),
        (array) config('backpack.base.middleware_key', 'admin')
    ),
    'namespace'  => 'App\Http\Controllers\Admin',
], function () { // custom admin routes
    Route::crud('customers', 'CustomersCrudController');
    Route::crud('pages', 'PagesCrudController');
    Route::crud('sliders', 'SlidersCrudController');
    Route::crud('banner', 'BannerCrudController');
    Route::crud('contact', 'ContactCrudController');
    Route::crud('enquires', 'EnquiresCrudController');
    Route::crud('ethical-channel', 'EthicalChannelCrudController');
    Route::crud('complaints', 'ComplaintsCrudController');
    Route::crud('news', 'NewsCrudController');
    Route::crud('divisions', 'DivisionsCrudController');
    Route::crud('services', 'ServicesCrudController');
    Route::crud('works', 'WorksCrudController');
    Route::crud('teams', 'TeamsCrudController');
    Route::crud('careers', 'CareersCrudController');

    Route::get('candidates', 'candidatesController@candidates') -> name('candidates');

    Route::get('deleteCandidates/{Candidates_id}', 'candidatesController@deleteCandidates')->name('candidates.delete');


    Route::post('eventsPost' ,'eventsController@eventsPost') -> name('eventsPost');

    Route::get('events', 'eventsController@events') -> name('events');

    Route::get('addEvents', 'eventsController@addEvents') -> name('addEvents');

    Route::get('eventsCandidates/{News_id}', 'eventsController@deleteNews')->name('events.delete');



    Route::get('editEvents/{News_id}', 'eventsController@editEvents') ->name('events.edit');

    Route::post('UpdateEvents/{News_id}', 'eventsController@UpdateEvents')->name('events.update');

}); // this should be the absolute last line of this file
