<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::group(['middleware' => ['localize', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath'] ], function() {


    Route::get('/', function () {
        return view('welcome');
    })->name('home');


    Route::get('/', 'HomeController@index')->name('home');

    Route::get('/services', 'PagesController@services')->name('services');
    Route::get('/services/{id}', 'PagesController@servicesdetails')->name('servicesdetails');
    Route::get('/work', 'PagesController@work')->name('workDetails');
    Route::get('/faq', 'PagesController@faq')->name('faq');

    Route::get('/page/{slug}', 'PagesController@page')->name('page');
    Route::get('/structure', 'PagesController@structure')->name('structure');
    Route::get('/division', 'PagesController@division')->name('division');
    Route::get('/divisiondetails/{id}', 'PagesController@divisiondetails')->name('divisiondetails');
    Route::post('/careerrefer', 'PagesController@referCareers')->name('refcareer');
    Route::post('/careers', 'PagesController@applyCareers')->name('subcareer');
    Route::get('/careers', 'PagesController@careers')->name('career');
    Route::get('/loadcareerform/{type}/{id}', 'PagesController@loadcareerform')->name('loadcareerform');
    Route::get('/news', 'PagesController@news')->name('news');
    Route::get('/news-2024', 'PagesController@news2024')->name('news2024');
    Route::get('/news-2025', 'PagesController@news2025')->name('news2025');
    Route::get('/news/{News_id}', 'PagesController@newsDetails')->name('newsDetails');


    Route::get('/contact-us', 'PagesController@contactus')->name('contact-us');
    Route::post('/contact-us', 'PagesController@postContactUs')->name('postcontact-us');
    Route::post('/pharmacovigilance', 'PagesController@postPharmacovigilance')->name('postPharmacovigilance');
    Route::get('/pharmacovigilance', 'PagesController@pharmacovigilance')->name('pharmacovigilance');
    Route::post('/quality', 'PagesController@postQuality')->name('postQuality');
    Route::get('/quality', 'PagesController@quality')->name('quality');
    Route::post('/compliance', 'PagesController@postcompliance')->name('postcompliance');
    Route::get('/compliance', 'PagesController@compliance')->name('compliance');
    Route::get('/AllNews', 'PagesController@AllNews')->name('AllNews');
    Route::post('/security', 'PagesController@postSecurity')->name('postSecurity');
    Route::get('/security', 'PagesController@security')->name('security');

    Route::post('/sendContactUs', 'PagesController@sendContactUs')->name('sendContactUs');
    Route::post('/search', 'PagesController@search')->name('search');

// switch language
});
// switch language
Route::get('/switch_lang/{locale}', function ($locale = '') {
    session(['locale' => $locale]);
    App::setLocale($locale);
    LaravelLocalization::setLocale($locale);
    return redirect()->back();
})->name('switch_lang');
